/****************************************************************
   Copyright (C) 2000  Stephen Humble.
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   Written by Stephen. T. Humble in  Perth Western Australia 
   data 10/1/2000 
   email steve@newton.dilaix.com.au
   Web site ucc.gu.uwa.edu.au/~steve
****************************************************************/

// new design opens a launcher window
// allows user to select which ports to access
// launches them and closes them, and adjusts window size to fit
// each address set is read from a seecial format data file
// with register names, descriptions, and addresses
// the launcher reads the data and launches based on this data

#include <qfont.h>
#include <qwidget.h>
#include <stdio.h>
#include <iostream>
using namespace std;
#include <qspinbox.h>
#include <qwidget.h>

#include <qcolor.h>
#include <qpalette.h>
#include "ppmPannel.hh"

ppmPannel::ppmPannel( QWidget *parent, const char *name )
  : QWidget( parent, name )
{
#define WIDE 60
#define HIGH 30
#define RHS  WIDE*7
  cout<<"new pannel starting\n";
  cout.flush();
  int row=0;		// used to increment rows as we add more buttons
  Ab=new parallelPort();

  PortSelect= new QSpinBox( 0,2,1,this,"LP selector");		
  // allow user to select port to look at
  PortSelect->setGeometry(0,row*HIGH,WIDE*4,HIGH);
  PortSelect->setPrefix("Monitor Port LP");
  PortSelect->setWrapping(TRUE);	// cool we can wrap
  connect( PortSelect, SIGNAL(valueChanged(int)),this, SLOT(ChangePort(int)) );
  row++;
  cout<<"new board\n";
  cout.flush();

  Bar=new QStatusBar(this,"Action display");
  Bar->setGeometry(0,row*HIGH,WIDE*8,HIGH);
  row++;

  // These buttons are set the data lines d0-d7 port+0
  for(int x=0;x<8;x++){
    char name[50];
    sprintf(name,"D%d out p%d",x,x+2);
    data_out[x] = new QPushButton( name, this, name );
    data_out[x]->setGeometry(RHS- x*WIDE,row*HIGH,WIDE,HIGH);
    data_out[x]->setToggleButton(TRUE);
    data_out[x]->setPalette(QPalette(QColor(40,140,230)));
    connect( data_out[x], SIGNAL(clicked()),this, SLOT(SetData_out()) );
  }
  row++;
  //Ab->get_data();
  // These Buttons show the data Read lines d0-d7 port+0
  // Setdata_outs(0);
  for(int x=0;x<8;x++){
    char name[50];
    sprintf(name,"D%d in p%d",x,x+2);
    data_in[x] = new QPushButton( name, this, name );
    data_in[x]->setGeometry(RHS- x*WIDE,row*HIGH,WIDE,HIGH);
  }
  row++;

  // These Buttons show the status port register lines port+1
  // Setdata_outs(0);
  char *spins[]= {  "nc","nc","nc","Error p15","Sel p13","POut p12","Ack p10","Busy p11"  };
  for(int x=0;x<8;x++){
    char name[50];
    sprintf(name,"status%d",x);
    status[x] = new QPushButton( spins[x], this, spins[x]);
    status[x]->setGeometry(RHS- x*WIDE,row*HIGH, WIDE,HIGH);
  }
  row++;

  // These Buttons set the control Lines port+2
  char *pins[]= {  "Str p1","LF p14","Init p16","Sel p17","nc","DATA I/O","nc","nc"  };
  for(int x=0;x<8;x++){
    char name[50];
    sprintf(name,"D%d",x);
    ctrl[x] = new QPushButton( pins[x], this, pins[x] );
    ctrl[x]->setGeometry(RHS - x*WIDE,row*HIGH,WIDE,HIGH);
    ctrl[x]->setToggleButton(TRUE);
    ctrl[x]->setPalette(QPalette(QColor(20,160,240)));
    //ctrl[x]->setAutoRepeat(TRUE);
    connect( ctrl[x], SIGNAL(clicked()),this, SLOT(SetCtrl()) );
  }
  row++;

  // These Buttons strobe the control Lines port+2
  for(int x=0;x<8;x++){
    strobe[x] = new QPushButton( pins[x], this, pins[x] );
    strobe[x]->setGeometry(RHS - x*WIDE,row*HIGH,WIDE,HIGH);
    // strobe[x]->setToggleButton(TRUE);
    strobe[x]->setPalette(QPalette(QColor(240,160,240)));
  }
  row++;

  Bar->message("This Program is under development - need to add EPP and ECP registers");
  // set a nice font for all the buttons.
  // this->setFontPropagation( AllChildren );
  // this->setFont( QFont( "Helvetica",10, QFont::Bold ) );
  startTimer(20); 		// 20ms=50hz Qt will send timer events to this object
  setMinimumSize( WIDE*9, row*HIGH);
}

void ppmPannel::resizeEvent( QResizeEvent * )
{
}

void ppmPannel::ChangePort(int p)
{
  parallelPort *nu=new parallelPort(p);
  if(nu==0)return;
  delete Ab;
  sprintf(buffer,"Using Port At Base Address 0x%X",nu->port);
  Bar->message(buffer);
  Ab=nu;
  return;
}

void ppmPannel::SetData_out()
{
  int i=0;
  for(int x=0;x<8;x++){
    if(data_out[x]->isOn()) i+=(1<<x);
  }
  sprintf(buffer,"Data port set to 0x%X",i);
  Bar->message(buffer);
  Ab->set_data((BYTE)i);
}

void ppmPannel::SetCtrl()
{
  int i=0;
  for(int x=0;x<8;x++){
    if(ctrl[x]->isOn()) i=i+(1<<x);
  }
  sprintf(buffer,"Control port set to 0x%X",i);
  Bar->message(buffer);
  Ab->set_Ctrl((BYTE)i);
}

	// QT calls this periodically once timer started
void ppmPannel::timerEvent(QTimerEvent *)
{
  static int cnt=1;
  Show_state();
  int bitStrobe=0;
  for(int x=0;x<8;x++){
    if(strobe[x]->isDown()) bitStrobe+=(1<<x);
  }
  if(( bitStrobe!=0 )|| !( cnt&1 )){
#ifdef DEBUG2
    cout<<"you pressed"<<bitStrobe;
    cout.flush();
#endif
    cnt++;
    if(cnt&1){  SetCtrl();
    }else{
      int i=0;
      for(int x=0;x<8;x++){
	if(ctrl[x]->isOn()) i=i+(1<<x);
      }
      Ab->set_Ctrl((BYTE)(bitStrobe^i));
    }
  }
}

void ppmPannel::Show_state()
{
  int i=(int)Ab->get_status();
  //cout<<i<<"start";
  for(int x=0;x<8;x++){
    //cout<<(1<<x)<<" ,";
    if((1<<x)&i){
      status[x]->setDown(TRUE);
    }else{
      status[x]->setDown(FALSE);
    }
  }
  i=(int)Ab->get_data();
  //cout<<i<<"start";
  for(int x=0;x<8;x++){
    //cout<<(1<<x)<<" ,";
    if((1<<x)&i){
      data_in[x]->setDown(TRUE);
    }else{
      data_in[x]->setDown(FALSE);
    }
  }
}


