//   Copyright (C) 2000  Stephen T Humble.
//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//   (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//     GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; if not, write to the Free Software
//   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
//   Written by Stephen. T. Humble in  Perth Western Australia 
//   data 10/1/2000 
//   email steve@newton.dilaix.com.au
//   Web site ucc.gu.uwa.edu.au/~steve
//
//   This is a class dedicated to reading and writing to parallel Ports.
//   Can be used seperatly - has no depecdancies (and ide like to keep it that way too)
#include <stdio.h>
#include <stdlib.h>
#include <iostream>
using namespace std;
#include <unistd.h>
#include <math.h>
#include <sys/stat.h>
#include <sys/io.h>
#include "parallel-port.hh"

#define VERBOSE yes_i_want_info
// see if we can access a parallel port p address
int parallelPort_getport(int p)
{
  if(p<0 || p>2) return 0;
  int port;
  int ports[]= {  0x278, 0x378, 0x3bc  };  // all possible parallel port addresses
  //int ports[]= {  0x378,0x278, 0x3bc  };
  port = ports[p];
  if (ioperm(port, 3, 1)<0){         // tell kernel we want to access some IO locations
    perror("Well that IO port sux");
    cerr<<"Port 0x"<<port<<" Will not concede \n";
    cerr<<"I suggest you check this program is running as root to access the IO parallel port\n";
    return 0;
  }
  else {
    return port;
  }
  cerr<<"Gee how did i reach this line something wierd is happening ie no ports will allow access.\n";
  return 0;
}


// get any parallel port at all
int parallelPort_find()
{
  int port;
  for(int p = 0; p < 3; p++){
    port=parallelPort_getport(p);
    if(port!=0)return(port);
  }
  cerr<<"I suggest you check this program is running as root to access the IO parallel port\n";
  cerr<<"Gee how did i reach this line something wierd is happening.\n";
  return(0);
}

parallelPort::parallelPort()
{
  port=parallelPort_find();
  if(port==0){
    cerr<<"unable to get a printer port for AB";
    exit(1);
  }
#ifdef VERBOSE
  cout.unsetf(ios::dec);
  cout.setf(ios::hex);
  cout<<"successfully accessed a parallel port at 0x"<<port<<"\n";
  cout.unsetf(ios::hex);
  cout.setf(ios::dec);
  cout.flush();
#endif
  return;
}

parallelPort::parallelPort(int p)
{
  port=parallelPort_getport(p);
  if(port==0){
#ifdef VERBOSE
    cout<<"unable to get a printer port for AB";
#endif
    exit(1);
  }
#ifdef VERBOSE
  cout.unsetf(ios::dec);
  cout.setf(ios::hex);
  cout<<"successfully accessed a parallel port at 0x"<<port<<"\n";
  cout.unsetf(ios::hex);
  cout.setf(ios::dec);
  cout.flush();
#endif
  return;
}

parallelPort::~parallelPort()
{
#ifdef VERBOSE
  cout.unsetf(ios::dec);
  cout.setf(ios::hex);
  cout<<"returning port 0x"<<port<<" to kernel \n";
  cout.unsetf(ios::hex);
  cout.setf(ios::dec);
  cout.flush();
#endif
  ioperm(port,3,0);		// well the kernel can have that port back
}

int parallelPort::set_Ctrl(BYTE s)
{
  outb(s,port+2);
#ifdef DEBUG
  cout<<"wrote "<<(int)s<<"\n";
  cout.flush();
#endif
  return(0);
}

BYTE parallelPort::get_status()
{
  BYTE in=inb(port + 1);
  //cout<<(int)in<<" ";
  return(in);
}

BYTE parallelPort::get_data()
{
  BYTE in=inb(port);
  //cout<<(int)in<<" ";
  return(in);
}

int parallelPort::set_data(BYTE s)
{
  outb(s,port);
#ifdef DEBUG
  cout<<"wrote "<<(int)s<<"\n";
  cout.flush();
#endif
  return(0);
}


