
def read_wfile(wfile):

"""Reads generic surface overlay ('W') file and provides

values for each of the vertex indices.

Based on the FreeSurfer fileformats described at

http://wideman-one.com/gw/brain/fs/surfacefileformats.htm

"""

    f = open(wfile, 'r')

    latency = struct.unpack('>h',f.read(2))[0] # first two
    bytes represent latency
    numvert = struct.unpack('>i','\x00' + f.read(3))[0] # read number of
    vertices (3 bytes)
    vertx_id = np.zeros(numvert,dtype=np.int)
    values = np.zeros((numvert,1))

    for i in xrange(numvert):
        vertx_id[i] = struct.unpack('>i','\x00' + f.read(3))[0]
        values[i] = struct.unpack('>f',f.read(4))[0]

    f.close()
    return [vertx_id,values]

