from struct import unpack, calcsize
from numpy import *

import vtk
from my_fs_flat_io import read_morph_data

pointfile = '/usr/share/freesurfer-5.1/subjects/fsaverage/surf/lh.cortex.patch.flat'

curvfile = '/usr/share/freesurfer-5.1/subjects/fsaverage/surf/lh.curv'

#create a vtk point array to hold our points
inputPoints = vtk.vtkPoints()

#load the flat file
f=open(pointfile, 'rb')
t,n = unpack(">ii", f.read(calcsize(">ii")))

#create a vertex array to hold point data, and the vertex mapping in the original surf file
vertex_dat = empty((n,4),'f');

#read in the data to the vertex and point array
for i in range(n):
    #append to vertex array
    vertex_dat[i,:] = unpack('>ifff', f.read(calcsize('>ifff')))
    #append to points list
    inputPoints.InsertPoint(i,vertex_dat[i,1:])

#close the input file
f.close()

print vertex_dat, inputPoints

# Create a polydata with the points we just created.
profile = vtk.vtkPolyData()
profile.SetPoints(inputPoints)

# Perform a 2D Delaunay triangulation on them.
delny = vtk.vtkDelaunay2D()
delny.SetInput(profile)
delny.SetTolerance(0.001)
delny.Update()

print delny


#now extract the scalar values representing curvature
curv = read_morph_data(curvfile)
print curv

#now do a bit of work and figure out which vertices we need curv for

lookupVertices = array(vertex_dat[:,0]-1,'i') #cast the first column of vertex array to int for indexing
print lookupVertices
print lookupVertices.shape

surfScalars = curv[lookupVertices] #this is why we need to keep track of correspondin verts in vertex_dat

sc_scalars = vtk.vtkFloatArray()
for val in surfScalars:
    sc_scalars.InsertNextValue(val)

print surfScalars

surfPolydata = delny.GetOutput()
surfPolydata.GetPoints()
surfPolydata.GetPointData().SetScalars(sc_scalars)
surfPolydata.Update()



surfMapper = vtk.vtkPolyDataMapper()
surfMapper.SetInput(surfPolydata)

surfActor = vtk.vtkActor()
surfActor.SetMapper(surfMapper)

# Create the usual rendering stuff
ren = vtk.vtkRenderer()
renWin = vtk.vtkRenderWindow()
renWin.AddRenderer(ren)
iren = vtk.vtkRenderWindowInteractor()
iren.SetRenderWindow(renWin)

# Add the actors to the renderer, set the background and size
ren.AddActor(surfActor)
ren.SetBackground(1, 1, 1)
renWin.SetSize(250, 250)
ren.ResetCamera()
ren.GetActiveCamera().Roll(0)
ren.GetActiveCamera().Dolly(0)
ren.ResetCameraClippingRange()

iren.Initialize()
renWin.Render()
iren.Start()




