
##Created by AG Jul 14
#Adapted and modified by SM 

# some modules for a GUI
import wxversion
wxversion.select('2.8')
import wx

#import the core modules we are going to use
import os, sys
import cv2.cv as cv
import numpy as np
import time

import cv2

#import some modules for some summary plots at the end
import matplotlib.pyplot as plt

#import some modules that allows us to read .mat files
import scipy.io

#import module to get files path and name
import os
#import ntpath - specific to windows

# -----------
global clickPoints, finalPoints, inFileName, matData, showFramesYesNo, x_start, x_end, gsmth, pupilIntensityThreshold, frameWaitKey

#some placeholders
matData = None
showFramesYesNo = None
pupilIntensityThreshold = 40
pupil_min_area = 500
pupil_max_area = 10000
frameWaitKey = 0

clickPointsSet = 0


### ------------------------------------------------- ###
# OPEN CV - engine room of the processing


def runPupilAnalysis(coordinates, inFileName, matData=None, runMode='initialSetup'):
    global x_start, x_end, gsmth, pupilIntensityThreshold, pupil_max_area, pupil_min_area, frameWaitKey
    
    #grabs the bounding coordinates of the reqgion of interest
    x, y, w, h, bg_x, bg_y, bg_w, bg_h = coordinates  

    x_min, y_min, x_size, y_size = x,y,w,h

    cv.NamedWindow("VideoFrames", cv.CV_WINDOW_AUTOSIZE)

    capture = cv.CreateFileCapture(inFileName)    

    cnt = 0 #keep track of which frame we're at

    if matData == None:
        #get the first frame  
        frame = cv.QueryFrame(capture)
        gray_img = cv.CreateImage((frame.width, frame.height),8,1)
    
    else:
        matTotalFrames = matData.shape[2]
        
        #get the first frame data     
        matFrame = matData[:,:,cnt].copy() #NB need the .copy() for correct handling by cv
        cvdat = cv.fromarray(matFrame)
        
        #set up a window to show the image
        gray_img = cv.CreateImage((matFrame.shape[1], matFrame.shape[0]),8,1)
        frame = cv.CreateImage((matFrame.shape[1], matFrame.shape[0]),8,3)

        cv.Merge(cvdat, cvdat, cvdat, None, frame)

    #images in memory to pass matrices to
    pupil_roi_img = cv.CreateImage((w, h),8,1)
    pupil_pos_img = cv.CreateImage((w, h),8,1)
    smooth_img = cv.CreateImage((w, h),8,1)


    # a counter to keep track of where we are in frames
    frameCount=0    

    print cv.GetCaptureProperty(capture, cv.CV_CAP_PROP_FPS)

    totalFrameCount = int(cv.GetCaptureProperty(capture, cv.CV_CAP_PROP_FRAME_COUNT))
    print 'total frames: %i' %totalFrameCount


    #lets keep hold of some values so that we can save our data
    pupil_area = np.zeros(totalFrameCount)
    pupil_pos_X = np.zeros(totalFrameCount)
    pupil_pos_Y = np.zeros(totalFrameCount)
    blinkDetected = np.zeros(totalFrameCount)
    blinkAtFrame = np.zeros(totalFrameCount)
    bg_value = np.zeros(totalFrameCount)

    runningCollection = 0 # allows break out of setup mode

    while (frameCount<totalFrameCount-2) and (runningCollection == 0):
        
        print 'frame%i' %frameCount
        
        
        
        #cast capture to 1 channel grayscale
        cv.CvtColor(frame, gray_img, cv.CV_BGR2GRAY)
        
        #get some background info restrict to roi
        #my_bg = cv.GetSubRect(gray_img,(bg_x, bg_y, bg_w, bg_h)) #bottom-right
        my_bg = cv.GetSubRect(gray_img,(10,10,bg_w, bg_h)) #top-left

        my_bg_avg = cv.Avg(my_bg)[0]
        
        bg_value[frameCount] = my_bg_avg
        
        x_max = x_min+x_size    
        y_max = y_min+y_size    

        #lets restrict our pupil data to a smaller FOV
        my_roi = cv.GetSubRect(gray_img,(x_min, y_min, x_size, y_size))

        #copy data to arrays we can work with
        cv.Copy(my_roi, pupil_roi_img)

        #
        cv.Threshold(pupil_roi_img,pupil_roi_img,pupilIntensityThreshold,255,0)
        
        cv.Smooth(pupil_roi_img, pupil_roi_img, cv.CV_GAUSSIAN, 9,9)

        storage1 = cv.CreateMemStorage(0)

        contours = cv.FindContours(pupil_roi_img, storage1, cv.CV_RETR_LIST, cv.CV_CHAIN_APPROX_SIMPLE)


        def contour_iterator(contour):
            while contour:
                yield contour
                contour = contour.h_next()

        [cx, cy] = [1,1] #place holder
        
        for c in contour_iterator(contours):
            thisArea = cv.ContourArea(c)
            if pupil_min_area <cv.ContourArea(c)< pupil_max_area:
                
                pupil_area[frameCount] = thisArea #save it
                print 'area %i' %int(thisArea)
                
                M = cv.Moments(c)
                
                cx = int(M.m10/M.m00)
                cy = int(M.m01/M.m00)
                
                print 'cx, cy', cx, cy
                
                #cv.DrawContours(pupil_roi_img,c,0,(0,255,0),2)
                cv.DrawContours(pupil_roi_img,c,0,255,-1)
                
        cv.FloodFill(pupil_roi_img, (cx,cy), (255,255,255),0,1)        
                
        ###
        
        cv.Copy(my_roi, pupil_pos_img)

        ## PUPIL POSITION CODE ------------
        
        try:
        
            #mark the pupil centre
            cv.Set2D(pupil_pos_img, cy, cx, ( 128, 128, 128,0))
            cv.Set2D(pupil_pos_img, cy-1, cx, ( 128, 128, 128,0))
            cv.Set2D(pupil_pos_img, cy+1, cx, ( 128, 128, 128,0))
            cv.Set2D(pupil_pos_img, cy, cx-1, ( 128, 128, 128,0))
            cv.Set2D(pupil_pos_img, cy, cx+1, ( 128, 128, 128,0))
            cv.Set2D(pupil_pos_img, cy-2, cx, ( 128, 128, 128,0))
            cv.Set2D(pupil_pos_img, cy+2, cx, ( 128, 128, 128,0))
            cv.Set2D(pupil_pos_img, cy, cx-2, ( 128, 128, 128,0))
            cv.Set2D(pupil_pos_img, cy, cx+2, ( 128, 128, 128,0))
            pupil_pos_X[frameCount] = cx
            pupil_pos_Y[frameCount] = cy          

        except:
            print 'Centre of mass at edge of image - probably a blink'
            print 'marking frame as blink event'
            blinkDetected[frameCount] = 1
            blinkAtFrame[frameCount] = frameCount
        
        #show if required
        if (showFramesYesNo) == 1 and (runMode == 'initialSetup'):            
            cv.ShowImage("pupil_centre", pupil_pos_img)
            cv.WaitKey(1)            
            cv.ShowImage('IMG',pupil_roi_img)
            cv.ShowImage('VideoFrames',gray_img)
            cv.ShowImage('IMGorig',my_roi)
            t = cv.WaitKey(frameWaitKey)
            print 't',t
            
            if t == 1113937: # left arrow
                pupilIntensityThreshold += 1
                print 'pupil intesity rescaled to : %s' %pupilIntensityThreshold
            elif t == 1113939: # right arrow
                pupilIntensityThreshold -= 1
                print 'pupil intesity rescaled to : %s' %pupilIntensityThreshold
            elif t == 1113938: # up arrow
                pupil_min_area += 25
                print 'pupil min area rescaled to : %s' %pupil_min_area
            elif t == 1113940: # +
                pupil_min_area -= 25 #down arrow
                print 'pupil min area rescaled to : %s' %pupil_min_area
            elif t == 1048689: # q
                print 'setup done .. analysing data'
                runningCollection = 1
            elif t == 1048624: # 0
                print 'frames wait'
                frameWaitKey = 0
            elif t == 1048625: # 1
                print 'frames dont wait'
                frameWaitKey = 1                            
            elif t == 1048620: # < ,
                pupil_max_area -= 100
                print 'pupil max area rescaled to : %s' %pupil_max_area                 
            elif t == 1048622: # > .
                pupil_max_area += 100
                print 'pupil max area rescaled to : %s' %pupil_max_area
                

        if matData == None:
            frame = cv.QueryFrame(capture)
            if inFileName[-3:] == 'ogg': # with OGG, OPENCV pick up two fields for each frame; just ignore every second frame. #TODO FIX??
                frame = cv.QueryFrame(capture)
        else:
            if cnt < matTotalFrames: #check we haven't run out of frames
                matFrame = matData[:,:,cnt].copy() #NB need the .copy() for correct handling by cv
                cvdat = cv.fromarray(matFrame)
                
                #set up a window to show the image
                gray_img = cv.CreateImage((matFrame.shape[1], matFrame.shape[0]),8,1)
                frame = cv.CreateImage((matFrame.shape[1], matFrame.shape[0]),8,3)
                cv.Merge(cvdat, cvdat, cvdat, None, frame)
            else: #we're out of data
                frame = None
                
        frameCount+=1


    area_data_final = np.array(pupil_area,'i')
    fig0 = plt.figure()
    plt.plot(area_data_final)
    plt.title('pupil area in voxels')    

    #once done .. do some plots
    fig1 = plt.figure()
    plt.plot(pupil_pos_X, pupil_pos_Y,'rx')
    plt.title('pupil xy')    

    fig2 = plt.figure()
    plt.plot(np.arange(totalFrameCount),blinkDetected)
    plt.title('blinks')
    
    fig3 = plt.figure()
    plt.plot(area_data_final,'r')
    plt.hold(1)
    plt.plot(np.arange(totalFrameCount),blinkDetected*1000)    
    plt.title('blinks plus area')
      

    #once done .. do some plots
    fig1 = plt.figure()
    plt.plot(pupil_pos_X[:550], pupil_pos_Y[:550],'rx')
    plt.title('pupil xy')    
       


    print pupilIntensityThreshold
    print pupil_min_area

    plt.show()
    
    if (runMode == 'initialSetup') and (showFramesYesNo == 1):
        runningSetupComplete = 1
        #and end
    else: # write out phase
        dlg = wx.MessageDialog(None, 
            "Save the data?",
            "Save the data? Yes to save, No to quit without saving ... ", wx.YES|wx.NO|wx.ICON_QUESTION)
        result = dlg.ShowModal()
        dlg.Destroy()
        if result == wx.ID_YES:
            #create a metaData string
            metaData = 'data used: %s, threshold=%s ; max_pupil_area=%s ; min_pupil_area=%s; ' %(inFileName, pupilIntensityThreshold, pupil_max_area, pupil_min_area)
	
            #write out arrays to results folder
            OutputFileName=os.path.basename(inFileName[:-4] ) #inFileName[:-4]: gives me all the characters except the last 4, full path and name without the extension; os.path.basename: retrieves just the name of the file
            np.savetxt("/scratch/groups/Projects/P1235/PhaseC/EyeTracker/PupilAnalyses/Results/"+OutputFileName+"pupil_area.csv", area_data_final, delimiter=",")#path to output file+name of the file, the data to be stored, delimiter
            np.savetxt("/scratch/groups/Projects/P1235/PhaseC/EyeTracker/PupilAnalyses/Results/"+OutputFileName+"pupil_bgMean.csv", bg_value, delimiter=",")
            np.savetxt("/scratch/groups/Projects/P1235/PhaseC/EyeTracker/PupilAnalyses/Results/"+OutputFileName+"pupil_pos_X.csv", pupil_pos_X, delimiter=",")
            np.savetxt("/scratch/groups/Projects/P1235/PhaseC/EyeTracker/PupilAnalyses/Results/"+OutputFileName+"pupil_posY.csv", pupil_pos_Y, delimiter=",")
            np.savetxt("/scratch/groups/Projects/P1235/PhaseC/EyeTracker/PupilAnalyses/Results/"+OutputFileName+"blinkBinary.csv", blinkDetected, delimiter=",")
            np.savetxt("/scratch/groups/Projects/P1235/PhaseC/EyeTracker/PupilAnalyses/Results/"+OutputFileName+"blinkAtFrameNumber.csv", blinkAtFrame, delimiter=",")
            f = open('/scratch/groups/Projects/P1235/PhaseC/EyeTracker/PupilAnalyses/Results/settings.txt','w')
            f.write(metaData)
            f.write('\n')
            f.close()

            #save the clipped video matrix
            print 'Data saved ...  processed %s \n\n\n' %inFileName
            print 'Settings: %s' %metaData 		
            sys.exit()
            
        else:
            print 'quitting without saving any data ... was processing %s \n\n\n' %inFileName
            sys.exit()




# END OPEN CV stuff
### ------------------------------------------------- ###


### ------------------------------------------------- ###
# GUI - allows us to pick points and input

class CvDisplayPanel(wx.Panel):
    #global clickPoints, inFileName
    
    def __init__(self, parent):
        global clickPoints, finalPoints, inFileName, matData, showFramesYesNo, pupilPoints, clickPointsSet, pupil_max_area, pupil_min_area
        wx.Panel.__init__(self, parent, -1)

        #load a file
        if len(sys.argv) > 1:
            inFileName = sys.argv[1]
            print 'Video file provided at command line:' , inFileName
        else:
            filters = 'avi files (*.avi)|*.avi|matlab files (*.mat)|*.mat|ogg files (*.ogg)|*.ogg|mpg files (*.mpg)|*.mpg'
            dialog = wx.FileDialog ( None, message = 'Open a video or matlab file ....', wildcard = filters, style = wx.OPEN)
            if dialog.ShowModal() == wx.ID_OK:
                inFileName = dialog.GetPath()
                print 'Video file selected in GUI:' , inFileName                
            else:
                print 'Nothing was selected. Quitting ...'
                sys.exit()
            dialog.Destroy()
        
        #determine the data type we are loading: avi, ogg or mat
        if inFileName[-3:] == 'avi':
            self.dataType = 'avi'
            #get a frame from the file
            self.capture = cv.CreateFileCapture(inFileName)
            for i in range(100):
                self.vidframe_orig = cv.QueryFrame(self.capture)
                cv.CvtColor(self.vidframe_orig, self.vidframe_orig, cv.CV_BGR2RGB)

            self.vidframe_copy = cv.CreateImage((self.vidframe_orig.width, self.vidframe_orig.height),8,3)
            cv.Copy(self.vidframe_orig, self.vidframe_copy)

        elif inFileName[-3:] == 'mpg':
            self.dataType = 'mpg'
            #get a frame from the file
            self.capture = cv.CreateFileCapture(inFileName)
            for i in range(100):
                self.vidframe_orig = cv.QueryFrame(self.capture)
                cv.CvtColor(self.vidframe_orig, self.vidframe_orig, cv.CV_BGR2RGB)

            self.vidframe_copy = cv.CreateImage((self.vidframe_orig.width, self.vidframe_orig.height),8,3)
            cv.Copy(self.vidframe_orig, self.vidframe_copy)

        elif inFileName[-3:] == 'ogg':
            self.dataType = 'ogg'
            #get a frame from the file
            self.capture = cv.CreateFileCapture(inFileName)
            for i in range(100):
                self.vidframe_orig = cv.QueryFrame(self.capture)
                cv.CvtColor(self.vidframe_orig, self.vidframe_orig, cv.CV_BGR2RGB)

            self.vidframe_copy = cv.CreateImage((self.vidframe_orig.width, self.vidframe_orig.height),8,3)
            cv.Copy(self.vidframe_orig, self.vidframe_copy)

        elif inFileName[-3:] == 'mat':
            self.dataType = 'mat'
            print 'loading data ...'
            #load the data
            mat = scipy.io.loadmat(inFileName)
            self.matData = np.array(mat['data'],'uint8')
            ##self.matData = np.array(mat['whole_small_data'],'uint8')
            matData = self.matData #for global parsing
            print 'loading done ...'
            #get a frame from the file
            matFrame = self.matData[:,:,100].copy() #NB need the .copy() for correct handling by cv
            self.matPos = 100 #need this in case we want to increment later
            cvdat = cv.fromarray(matFrame)
            #now set up an image to show it
            self.vidframe_orig = cv.CreateImage((self.matData.shape[1], self.matData.shape[0]),8,3)
            
            cv.Merge(cvdat, cvdat, cvdat, None, self.vidframe_orig)
            
            self.vidframe_copy = cv.CreateImage((self.matData.shape[1], self.matData.shape[0]),8,3)

            cv.Copy(self.vidframe_orig, self.vidframe_copy)
            #cvRectangle(
            #   myImg,
            #   cvPoint(5,10),
            #   cvPoint(20,30),
            #   cvScalar(255,255,255)
            #);




        else:
            print 'Problem! - file type not recognised (not .mat or .avi) ... Quitting ...'
            sys.exit()
                        

        frame = wx.Frame(self, -1, size=(self.vidframe_copy.width, self.vidframe_copy.height))      
        frame.Show(True)

        # Convert the raw image data to something wxpython can handle.
        self.bmp = wx.BitmapFromBuffer(self.vidframe_copy.width, self.vidframe_copy.height,\
                                       self.vidframe_copy.tostring())
        # Display the resulting image
        self.sbmp = wx.StaticBitmap(self, -1, bitmap=self.bmp)
        
        self.sbmp.Bind(wx.EVT_LEFT_DOWN, self.LeftClick)
        self.sbmp.Bind(wx.EVT_RIGHT_DOWN, self.ReturnCoords)
        self.sbmp.Bind(wx.EVT_LEFT_DCLICK, self.NextFrame)

        clickPoints = []


    def LeftClick(obj, evt):
        global clickPoints, pupilPoints 
        print 'click'
        print evt.GetPosition()
        

        clickPoints.append(evt.GetPosition())

        cv.Copy(obj.vidframe_orig, obj.vidframe_copy) 

        if len(clickPoints)%4 == 0:
            if len(clickPoints) >  3:
                pup_pt1, pup_pt2 = clickPoints[-2], clickPoints[-1]
                cv.Rectangle(obj.vidframe_copy,(int(pup_pt1[0]), int(pup_pt1[1])),(int(pup_pt2[0]), int(pup_pt2[1])),(255,255,0))
                bg_pt1, bg_pt2 = clickPoints[-4], clickPoints[-3]
                cv.Rectangle(obj.vidframe_copy,(int(bg_pt1[0]), int(bg_pt1[1])),(int(bg_pt2[0]), int(bg_pt2[1])),(148,148,148))

        obj.bmp = wx.BitmapFromBuffer(obj.vidframe_copy.width, obj.vidframe_copy.height,\
                                       obj.vidframe_copy.tostring())
        # Display the resulting image
        obj.sbmp.SetBitmap(obj.bmp)
        
 
  
    def ReturnCoords(obj, evt):
        global clickPoints, finalPoints, showFramesYesNo


        pt1, pt2 = clickPoints[-2], clickPoints[-1]
        w, h = (pt2[0]-pt1[0]), pt2[1]-pt1[1] 
        x, y = pt1[0], pt1[1]
        bg_pt1, bg_pt2 = clickPoints[-4], clickPoints[-3]
        bg_w, bg_h = (bg_pt2[0]-bg_pt1[0]), bg_pt2[1]-bg_pt1[1] 
        bg_x, bg_y = bg_pt1[0], bg_pt1[1]

        finalPoints = x, y, w, h, bg_x, bg_y, bg_w, bg_h
        
        print 'Now pick points around the pupil to get the rough pupil size'

        dlg = wx.MessageDialog(obj, 
            "Would you like to see the frames and run and change settings?",
            "View video frames?", wx.YES|wx.NO|wx.CANCEL|wx.ICON_QUESTION)
        result = dlg.ShowModal()
        dlg.Destroy()
        if result == wx.ID_YES:
            showFramesYesNo = 1
            obj.GetParent().Destroy()
        elif result == wx.ID_NO:
            showFramesYesNo = 0
            obj.GetParent().Destroy()
        else:
            pass #do nought
    


    def NextFrame(obj, evt):
        print 'trying a different frame ... jumping 120 frames ahead'
        #get a different frame from the file
        if obj.dataType == 'avi':
            for i in range(120):
                obj.vidframe = cv.QueryFrame(obj.capture)
                cv.CvtColor(obj.vidframe_orig, obj.vidframe_orig, cv.CV_BGR2RGB)
        elif obj.dataType == 'ogg':
            for i in range(120):
                obj.vidframe = cv.QueryFrame(obj.capture)
                cv.CvtColor(obj.vidframe_orig, obj.vidframe_orig, cv.CV_BGR2RGB)
        elif obj.dataType == 'mpg':
            for i in range(120):
                obj.vidframe = cv.QueryFrame(obj.capture)
                cv.CvtColor(obj.vidframe_orig, obj.vidframe_orig, cv.CV_BGR2RGB)                

        elif obj.dataType == 'mat':
            obj.matPos += 120
            matFrame = obj.matData[:,:,obj.matPos].copy() #NB need the .copy() for correct handling by cv

            cvdat = cv.fromarray(matFrame)
            cv.Merge(cvdat, cvdat, cvdat, None, obj.vidframe_orig)            

        # Convert the raw image data to something wxpython can handle
        obj.bmp = wx.BitmapFromBuffer(obj.vidframe_orig.width, obj.vidframe_orig.height,\
                                       obj.vidframe_orig.tostring())
        # Display the resulting image
        obj.sbmp = wx.StaticBitmap(obj, -1, bitmap=obj.bmp)
        clickPoints = []
        

# END GUI code
### ------------------------------------------------- ###


if __name__=="__main__":
    app = wx.App()
    app.RestoreStdio()
    frame = wx.Frame(None, -1, size=(800,520))
    CvDisplayPanel(frame)
    frame.Show(True)
    app.MainLoop()
    
    print 'using this point data: ', finalPoints
    #runPupilSetup(finalPoints, inFileName, matData)
    runPupilAnalysis(finalPoints, inFileName, matData, 'initialSetup')
    runPupilAnalysis(finalPoints, inFileName, matData, 'processData')   











