from numpy import *
import sys
import matplotlib.pyplot as plt

import mdp

dType = 'Passiv'
dType = 'ActCen'
dType = 'ActPer'



f = open('/groups/Projects/P1174/data/analysis/2010_results/2010_%s_pupil_area.txt' %dType)
pupil_area_dat = f.readlines()
f.close()

f = open('/groups/Projects/P1174/data/analysis/2010_results/2010_%s_pupil_bgMean.txt' %dType)
pupil_bg_dat = f.readlines()
f.close()

f = open('/groups/Projects/P1174/data/analysis/2010_results/2010_%s_pupil_meta.txt' %dType)
pupil_meta = f.readlines()
f.close()

if len(pupil_area_dat) == len(pupil_bg_dat) == len(pupil_meta): #sanity check 
    pass
else:
    sys.exit


all_area_dat = ones((len(pupil_area_dat),7680),'f')*nan
all_area_dat_raw = ones((len(pupil_area_dat),7680),'f')*nan
all_indiv_fourier = ones((len(pupil_area_dat),7680),'f')*nan
all_bg_dat = ones((len(pupil_area_dat),7680),'f')*nan

#all_area_dat = zeros((40,7680),'f')
#all_area_dat_raw = zeros((40,7680),'f')
#all_indiv_fourier = zeros((40,7680),'f')
#all_bg_dat = zeros((40,7680),'f')

if dType == 'ActPer':
    excludes = [37]# this dataset has a big dc shift that causes an artifact
else:
    excludes = []


#for i in range(24):
for i in range(len(pupil_meta)):

    if i in excludes: 
        pass
    else:

        #get the first frame position
        #for 2011 data this is 7680 frames before the end flash
        cf = int(pupil_meta[i].strip().split(',')[1].split('=')[-1]) -7680
        #print 'jumping to frame %s' %cf
        area_data = array(pupil_area_dat[i].strip().split(', '),'f')
        area_data = array(area_data[cf:cf+7680],'float32')
        bg_data = array(pupil_bg_dat[i].strip().split(', '),'i')
        bg_data = bg_data[cf:cf+7680]
        ## .. do some plots
        #fig = plt.figure()
        #plt.plot(bg_data)
        #plt.plot(area_data)
        #plt.show()
        #generate some timeseries with the blinks removed
        #first use the gradient change to detect probable blinks
        area_data_offset1 = hstack((area_data[1:], area_data[0])) # wrap by 1 
        area_data_offset2 = hstack((area_data[2:], area_data[0:2])) # wrap by 2
        area_data_offset3 = hstack((area_data[3:], area_data[0:3])) # wrap by 3  
        dy =  area_data - area_data_offset1
        dy2 = area_data - area_data_offset2
        dy3 = area_data - area_data_offset3 
        #fig = plt.figure()
        #plt.plot(bg_data)
        #plt.plot(dy)
        #plt.plot(dy2)
        #plt.plot(dy3)
        #copy the orignal series so we can amend it
        area_data_copy = area_data.copy()
        probBlinks = nonzero(abs(dy)>50)[0]
        for j in range(len(probBlinks)-2):
            #plt.plot(probBlinks[j], area_data_offset1[probBlinks[j]],'rx' )
            area_data_copy[probBlinks[j]+1] = 0
            area_data_copy[probBlinks[j]+2] = 0
        probBlinks = nonzero(abs(dy2)>50)[0]
        for j in range(len(probBlinks)-2):
            #plt.plot(probBlinks[j], area_data_offset2[probBlinks[j]],'rx' )
            area_data_copy[probBlinks[j]+1] = 0
            area_data_copy[probBlinks[j]+2] = 0
        probBlinks = nonzero(abs(dy3)>50)[0]
        for j in range(len(probBlinks)-2):
            #plt.plot(probBlinks[j], area_data_offset3[probBlinks[j]],'rx' )
            area_data_copy[probBlinks[j]+1] = 0
            area_data_copy[probBlinks[j]+2] = 0
        #final tidy - amplitude based
        for j in range(len(area_data_copy)):
            if area_data_copy[j] >1000:
                area_data_copy[j-2:j+3] = 0
            if area_data[i] >1000:
                area_data_copy[j-2:j+3] = 0
        #plt.plot(area_data,'r')      
        area_data_final = area_data_copy.copy() 
        area_data_copy[-1] = 100     
        
        do_interpolate_blinks_period = 0
        do_Nan_blinks_period = 1
        
        if do_interpolate_blinks_period == 1:
            smth_cnt = 0
            while smth_cnt < len(area_data_copy):
                #print 'act i:', smth_cnt
                if area_data_copy[smth_cnt] == 0:
                    #print 'got 0 at ', smth_cnt
                    start_index = smth_cnt
                    evt_track = 1
                    while area_data_copy[smth_cnt+evt_track] == 0:              
                        evt_track += 1        
                    smth_cnt = smth_cnt + evt_track-1
                    #print 'evt ended at ', smth_cnt
                    end_index = smth_cnt
                    smth_cnt += 1
                    area_data_final[start_index:end_index+1] = linspace(area_data_copy[start_index-1], area_data_copy[end_index+1], (end_index-start_index+3))[1:-1]
                else:
                    smth_cnt+=1

        elif do_Nan_blinks_period == 1:
            #first conevert all zeros values to NaNs
            area_data_final[area_data_final==0] = nan
            
        
        #plt.plot(area_data_final,'g')
        #plt.title(pupil_meta[i])    
        #plt.show()
        
        plot_indiv = 0

        signal = area_data_final
        fourier = fft.fft(signal)

        if plot_indiv == 1:
            plt.figure()
            n = signal.size
            timestep = (1/30.0)
            freq = fft.fftfreq(n, d=timestep)
            plt.plot(freq, abs(fourier))
            plt.ylim(-100,50000)
            plt.xlim(-0.0,0.33)
            fois = [0.03125, 0.0625, 0.125]
            for val in fois:
                x = ones(50000)*val
                y = arange(50000)
                plt.plot(x,y)
            plt.title('data run %s' %str(i+1))
            plt.legend(('abs(fft)', '1/32Hz','1/16Hz', '1/8Hz'))
            plt.show()



        #append individual vals to array
        all_area_dat[i,:] = area_data_final
        all_area_dat_raw[i,:] = area_data
        all_indiv_fourier[i,:] = abs(fourier)
        all_bg_dat[i,:] = bg_data
        
        #fig = plt.figure()
        #plt.plot(bg_data)
        #plt.title(str(i))
        ##meanBGsc = bg_data.reshape(8,7680/8.0)
        ##meanBGsc = meanBGsc.mean(0)
        ##fig = plt.figure()
        ##plt.plot(meanBGsc)
        ##plt.title(str(i))
        #plt.show()


all_area_dat.tofile('/tmp/pupilArea.txt',',')

#signal = mean(all_area_dat,0)

signal = ma.masked_invalid(all_area_dat).mean(0)

#string for title bar
if do_interpolate_blinks_period == 1:
    my_str = 'blinkPeriod=Interpolate'
elif do_Nan_blinks_period == 1:
    my_str = 'blinkPeriod=Nan'


#plot mean TS
fig = plt.figure()
plt.plot(signal.data)
plt.title('Mean TS of all runs with %s' %my_str)
plt.ylabel('Pupil area in pixels')
plt.xlabel('Video frame sample number (at 30Hz)')
#plt.ylim(80,140)

#plot FFT of mean
fourier = fft.fft(signal)
n = signal.size
timestep = (1/30.0)
freq = fft.fftfreq(n, d=timestep)
fig = plt.figure()
plt.plot(freq, abs(fourier))
plt.ylim(-100,25000)
plt.xlim(-0.0,0.33)
fois = [0.03125, 0.0625, 0.125]
for val in fois:
    x = ones(25000)*val
    y = arange(25000)
    plt.plot(x,y)

plt.title('FFT of mean TS of all runs with %s' %my_str)
plt.legend(('abs(fft)', '1/32Hz','1/16Hz', '1/8Hz'))
plt.ylabel('Abs')
plt.xlabel('f')


##plot mean FFT
#fig = plt.figure()
#plt.plot(freq, mean(all_indiv_fourier,0))
#plt.ylim(-100,25000)
#plt.xlim(-0.0,0.33)
#fois = [0.03125, 0.0625, 0.125]
#for val in fois:
#    x = ones(25000)*val
#    y = arange(25000)
#    plt.plot(x,y)
#
#plt.title('Mean of FFTs of all runs with %s' %my_str)
#plt.legend(('abs(fft)', '1/32Hz','1/16Hz', '1/8Hz'))
#plt.ylabel('Abs')
#plt.xlabel('f')


#plot bg mean

meanBG = ma.masked_invalid(all_bg_dat).mean(0)
fig = plt.figure()
plt.plot(meanBG)
plt.title('Mean BG of all runs with %s' %my_str)

meanBGsc = meanBG.reshape(8,7680/8.0)
meanBGsc = meanBGsc.mean(0)
fig = plt.figure()
plt.plot(meanBGsc)
plt.title('Mean single cycle of BG of all runs with %s' %my_str)


#plot single cycle of meanTS
scSignal = signal.data
scSignal = scSignal.reshape(8,7680/8.0)
scSignal = scSignal.mean(0)
fig = plt.figure()
plt.plot(scSignal)
plt.title('SC of TS of all runs with %s' %my_str)
plt.ylabel('Pupil area in pixels')
plt.xlabel('Video frame sample number (at 30Hz)')
#plt.ylim(80,140)

y = arange(min(scSignal),max(scSignal),0.05)
x = ones(len(y))*480
plt.plot(x,y,'r')

plt.show()



    
    
    
    

##plot mean FFT
#fig = plt.figure()
#plt.plot(freq, mean(all_indiv_fourier,0))
#plt.ylim(-100,25000)
#plt.xlim(-0.0,0.33)
#fois = [0.03125, 0.0625, 0.125]
#for val in fois:
#    x = ones(25000)*val
#    y = arange(25000)
#    plt.plot(x,y)
#
#plt.title('Mean of FFTs of all runs with %s' %my_str)
#plt.legend(('abs(fft)', '1/32Hz','1/16Hz', '1/8Hz'))
#plt.ylabel('Abs')
#plt.xlabel('f')


#plot bg mean

meanBG = mean(all_bg_dat,0)
fig = plt.figure()
plt.plot(meanBG)
plt.title('Mean BG of all runs')

meanBGsc = meanBG.reshape(8,7680/8.0)
meanBGsc = meanBGsc.mean(0)
fig = plt.figure()
plt.plot(meanBGsc)
plt.title('Mean single cycle of BG of all runs')


#plot single cycle of meanTS
scSignal_interp = signal_interp.data
scSignal_interp = scSignal_interp.reshape(8,7680/8.0)

scSignal_interp = scSignal_interp.mean(0)
fig = plt.figure()
plt.plot(scSignal_interp)
plt.title('SC of TS of all runs: interp')
plt.ylabel('Pupil area in pixels')
plt.xlabel('Video frame sample number (at 30Hz)')
#plt.ylim(80,140)

y = arange(min(scSignal_interp),max(scSignal_interp),0.05)
x = ones(len(y))*480
plt.plot(x,y,'r')


#plot single cycle of meanTS
scSignal_nan = signal_nan.data
scSignal_nan = scSignal_nan.reshape(8,7680/8.0)

scSignal_nan = scSignal_nan.mean(0)
fig = plt.figure()
plt.plot(scSignal_nan)
plt.title('SC of TS of all runs: nan')
plt.ylabel('Pupil area in pixels')
plt.xlabel('Video frame sample number (at 30Hz)')
#plt.ylim(80,140)


y = arange(min(scSignal_nan),max(scSignal_nan),0.05)
x = ones(len(y))*480
plt.plot(x,y,'r')

plt.show()



    
    
    
    
