import cv2.cv as cv
import numpy as np

import cv2

img = cv.LoadImage('/tmp/Selection_001.png')

gray = cv.CreateImage((img.width, img.height),8,1)
gray2 = cv.CreateImage((img.width, img.height),8,1)

cv.CvtColor(img,gray,cv.CV_BGR2GRAY)
cv.Threshold(gray,gray,15,255,0)

cv.Copy(gray,gray2)


storage = cv.CreateMemStorage(0)

contours = cv.FindContours(gray, storage, cv.CV_RETR_LIST, cv.CV_CHAIN_APPROX_SIMPLE)


def contour_iterator(contour):
    while contour:
        yield contour
        contour = contour.h_next()


#contours, hier = cv2.findContours(gray,cv2.RETR_LIST,cv2.CHAIN_APPROX_SIMPLE)
for c in contour_iterator(contours):
    if 10<cv.ContourArea(c)<50000:
    	print c
        cv.DrawContours(gray2,c,0,(0,255,0),2)
        cv.DrawContours(gray,c,0,255,-1)
        
        

cv.ShowImage('IMG',gray)
cv.ShowImage('IMGorig',gray2)
cv.WaitKey(0)

