#!/usr/bin/python


#a script to display the software logo on startup

import wx
import os

def get_path(path):
    return os.path.join(os.path.split(__file__)[0], path)


class MyFrame(wx.Frame):
    def __init__(self, parent, id, title):
        wx.Frame.__init__(self, parent, id, title, size = (387, 290))
        
        #load the logo jpeg
        self.bitmap = wx.Bitmap(get_path('ynicDV3Dlogo.jpg'))
        wx.EVT_PAINT(self, self.OnPaint)
        
        #place it in the centre of the screen
        self.Centre()

    def OnPaint(self, event):
        dc = wx.PaintDC(self)
        dc.DrawBitmap(self.bitmap, 5, 5)


class MyApp(wx.App):
    def OnInit(self):
        frame = MyFrame(None, -1, 'ynic DV3D - (c) 2006-2007')
        frame.Show(True)
        self.SetTopWindow(frame)

        import time
        import sys
        a = time.time()
        
        #now keep the logo visible for a few seconds 
        #(in the background if required) but close it 
        #automaticall after 15 seconds
        
        while time.time() < a+15:
            time.sleep(3)
        sys.exit()
        return True
        


app = MyApp(0)
app.MainLoop()
