from tYNI_imports import *
import vtk

(meshActor, polyData) = import_cortex_data('/home/andre/scratch/new_surfaces/ff.off')

ko = vtk.vtkQuadricDecimation()

ko.SetInput(polyData)

ko.SetTargetReduction(0.85)

y = vtk.vtkPolyDataMapper()

y.SetInput(ko.GetOutput())

y.Update()

t = vtk.vtkActor()
t.SetMapper(y)

ren1 = vtk.vtkRenderer()
ren1.AddActor(t)
ren1.SetBackground(0.1, 0.2, 0.4)

renWin = vtk.vtkRenderWindow()
renWin.AddRenderer(ren1)
renWin.SetSize(300, 300)

iren = vtk.vtkRenderWindowInteractor()
iren.SetRenderWindow(renWin)

style = vtk.vtkInteractorStyleTrackballCamera()
iren.SetInteractorStyle(style)

iren.Initialize()
iren.Start()

