function [V,mrGrayFileName]=analyze2mrGray(analHeaderFileName);
% function [V,mrGrayFileName]=analyze2mrGray(analHeaderFileName);
% Converts Analyze7.5 images to Stanford VISTA lab / mrGray vAnatomy.dat format.
% Analyze headers hold far more information that mrGray volumes. We just toss this information out when we write the mrGray file
% but this routine returns the Analyze header info in 'V'.
% Uses the SPM99 spm_vol command to parse the header. Uses misc. VISTA lab routines to write the volume.
% See also mrGray2Analyze

% ARW 081701


% Read the header
V=spm_vol(analHeaderFileName);

% Now read in the image data

fid=fopen(V.fname,'rb')
if (~fid)
    error (['Could not read header file: ',analHeaderFileName]);
end

im=fread(fid,inf,'uint8');
fclose(fid);
imLen=length(im);

if(imLen~=prod(V.dim(1:3)))
    error('Wrong data size.');
end

img=reshape(im,V.dim(1:3));
mmPerVox=diag(V.mat(1:3,1:3));
mmPerVox=mmPerVox;



% Need to rearrange the image. Analyze data run with sag and axial directions flipped. Also upside down in mrGray...                 
newimg=zeros(V.dim(3),V.dim(2),V.dim(1));
for thisIm=1:(V.dim(2))
   newimg(:,thisIm,:)=flipud(squeeze(img(:,thisIm,:))');
end


% Now write out a mrGray file 
mrGrayFileName = writeVolAnat(newimg, mmPerVox);
