function [view,OK] = meshLoad(view,mshFileName);
% Load mesh from a file and add it to the 3D gray view.
%
%  [view,OK] = meshLoad(view,mshFileName);
%
% When we load the mesh, we also compute the vertexGrayMap on the fly.
% This defines the mapping from the mesh vertices into gray matter for
% that particular data set (defined in view).
%

if ieNotDefined('mshFileName'), mshFileName = []; end
OK = 1;

[msh meshDir] = mrmReadMeshFile(mshFileName);
if(isempty(msh)), OK = 0; return; end

% Updates the mesh mesh to a new format directly readable by the mex files
% GB 02/13/05
msh = meshFormat(msh);

% Create the appropriate map from mesh vertices to gray matter.  This can
% differ from session to session because we acquire different slices.
%
if isempty(meshGet(msh,'vertexGrayMap'))
    vertexGrayMap = mrmMapVerticesToGray(...
        meshGet(msh, 'initialvertices'), ...
        viewGet(view, 'nodes'), ...
        viewGet(view, 'mmPerVox'),...
        viewGet(view, 'edges'));

    msh = meshSet(msh, 'vertexgraymap', vertexGrayMap);
end

msh = meshSet(msh,'id',-1);

if(~isfield(msh, 'fibers')), msh = meshSet(msh, 'fibers', []); end

view = viewSet(view,'addandselectmesh',msh);

return;