function newMsh = meshFormat(oldMsh,newMsh)
%
%    newMsh = meshFormat(oldMsh,[newMsh])
%
% GB 02/13/05
%
% Updates an older mesh object (oldMesh) to the new mesh format.
% The old field values that still are used are copied to the new mesh.
% Other fields, which are unused, are not copied.
%
% This routine can also be used to copy multiple fields from a partial
% mesh, (oldMesh), into a properly formatted new mesh (newMsh).
%
% Examples:
%
%

if ieNotDefined('newMsh'), newMsh = meshCreate; 
elseif ~meshCheck(newMsh); 
    error('First mesh must be defined consistent with meshCreate'); 
end

% Get the field names defined by meshCreate into a cell array
fields = fieldnames(newMsh);

% Copy any of the fields in the partial mesh into the new mesh that we
% output.  The new mesh has a flat data structure.  The old mesh had one
% field (data) with subfields in it. 
for ii=1:length(fields)
    if checkfields(oldMsh,fields{ii}) || checkfields(oldMsh,'data',fields{ii})
        newMsh = meshSet(newMsh,fields{ii},meshGet(oldMsh,fields{ii}));
    end
end

return;

    