function colors = meshData2Colors(data,cMap,range,scaleFlag);
%
%   colors = meshData2Colors(data,cMap,range,[scaleFlag]);
%
% Author: Ress
% Purpose:
%     Create a set of colormap data that correspond to each input value.  The
% color map indices are scaled to account for the indput range and the size
% of the color map.
%
% scaleFlag: if 1, will scale the data to fit the input range; otherwise,
% don't scale at all.
%
% More explanation goes here.
% This routine is oddly named, no?  It makes colors, it doesn't make
% indices.  Once we are sure about this, let's change the call to something
% like meshData2Colors(data,cMap,range).  (BW).
%
% 02/04 Agreed--adapted this from MakeCMapIndices, included option to not
% scale the data (e.g. if you have a discrete number of values on your map, 
% with a corresponding # of colors on the cmap). -ras
% 2005.08.11 RFD: passing an empty range now has the same effect as scaleFlag=0 

if ~exist('scaleFlag','var')    scaleFlag = 1;      end
if isempty(range)    scaleFlag = 1;      end

% if the data are empty (e.g., we're in anat mode and just want to view
% the ROIs), don't do this.
if isempty(data) | sum(data)==0
    colors = zeros(3, size(data,1));
    return; 
end

% Number of colors in the color map.
nMap = max(size(cMap));

if scaleFlag==1
    % scale data into number of colors in map:
    cMapIndices = rescale2(data,range,[1 nMap]);

    % ignore NaNs:
    cMapIndices = cMapIndices(~isnan(data));
    
    % now map colormap to each data point, given the color map:
    colors = cMap(:,cMapIndices);
else        
    % don't scale.
    vals = unique(data(data>0)); % the unique (non-zero) data in the data
    nDataVals = length(vals); 
    whichInds = round(linspace(1,nMap,nDataVals));
    
    % for each unique value in the data, manually
    % look up the proper color. This should only
    % be used for maps with a small number of 
    % distinct colors (like multiple overlays), 
    % otherwise this takes a long time to run through:
    colorIndices = ones(size(data)); 
    for i = 1:nDataVals
        colorIndices(data==vals(i)) = whichInds(i);
    end
    
	colors = cMap(:, colorIndices);
end


return;


% Older code:
% 	% Scale data onto input range, then find appropriate colors:
% 	data = (data-range(1)) ./ diff(range);
% 	
% 	% Ugh.
% 	data = 1 + round((nMap-1) * data);
% 	data(data<1) = 1;
% 	data(data>nMap) = nMap;
%     data = data(~isnan(data));
% 	colors = cMap(:, data);
