function val = meshCheck(msh)
%meshCheck -- Verify that the mesh structure is consistent with meshCreate
%
%   meshCheck(msh)
%
% Example
%
%   meshCheck(meshCreate)
%
%   msh.vertices = 0;
%   meshCheck(msh)


fields = fieldnames(meshCreate);
val = (length(fields) == length(fieldnames(msh)));
if val == 0, return; end

for ii=1:length(fields)
    if ~isfield(msh,fields{ii}), val = 0; return; end
end

return;

