function inplane = vol2ipAllROIs(volume,inplane)
%
% inplane = vol2ipAllROIs(volume,inplane)
%
% Calls vol2ipROI with all ROIs.
%
% rmk, 1/15/99
% djh, 2/2001, replaced globals with local variables

% if ~volume.selectedROI
%   myErrorDlg('Must have a selected ROI in the Volume window before it can be transformed to the Inplane window.');
% end

for r=1:length(volume.ROIs)
  volROI = volume.ROIs(r);
  ipROI = vol2ipROI(volROI,volume,inplane);
  inplane = addROI(inplane,ipROI,1);
end

