function view = importMap(view, srcMapPath, srcScan, tgtScan);
% Import parameter map  from another session into the selected
% data type / scan for the current session. Only works for Volume / Gray
% views, and for sessions which share a common volume anatomy.
%
% view = importMap(<view>, <srcMapPath>, <srcScan>, tgtScan);
% 
% If any of the latter three arguments are omitted, pops up a dialog.
% srcMapFile: path to map file to import
%
% ras, 01/06.
if notDefined('view'),    view = getSelectedGray;       end

if ~ismember(view.viewType, {'Volume' 'Gray'})
    error('Sorry, only Volume/Gray Views for now.')
end

mrGlobals;

% the session dir should be 2 parent directories above the map data dir
[par srcDt] = fileparts(fileparts(srcMapPath));
srcSession = fileparts(par);

% load source mrSESSION file
src = load(fullfile(srcSession,'mrSESSION.mat'));

if notDefined('srcMapPath')
    startDir = fullfile(srcSession, view.viewType);
    [f p] = myUiGetFile(startDir, '*.mat', 'Select a map to import');
    srcMapPath = fullfile(p,f);
end

% check that an appropriate map file exists, and if so, load it
if ~exist(srcMapPath, 'file')
    error(sprintf('%s not found.', srcMapPath));
else
    src = load(srcMapPath, 'map', 'mapName');
end
    
% load source coords, find indices of those
% coordinates contained within view's coords
% disp('Checking source and target coordinates...')
srcCoordsFile = fullfile(srcSession, view.viewType, 'coords.mat');
load(srcCoordsFile, 'coords');
[commonCoords, Isrc, Itgt] = intersectCols(coords, view.coords);
nVoxels = size(view.coords, 2);

% get target data type, scan number:
tgtDtNum = view.curDataType;
tgtDt = dataTYPES(tgtDtNum).name;
tgtScan = view.curScan;

% if an existing parameter map file exists for the target session,
% load that up, or else initialize to empty:
mapName = src.mapName;
[p f ext] = fileparts(srcMapPath);
savePath = fullfile(dataDir(view), [f '.mat']);
if exist(savePath, 'file')
    load(savePath, 'map'); 
else
    map = cell(1, numScans(view));
end

% initialize map volume
map{tgtScan} = zeros(1, nVoxels);

% copy over map data
fprintf('Importing map from %s %s %i \n', srcSession, srcDt, srcScan)
fprintf('\tto %s %s %i ...\n', mrSESSION.sessionCode, tgtDt, tgtScan);

map{tgtScan}(Itgt) = src.map{srcScan}(Isrc);

% save the results
if exist(savePath, 'file')
    save(savePath, 'map', 'mapName', '-append');
else
    save(savePath, 'map', 'mapName');
end    
view = setParameterMap(view, map, mapName);
% refreshScreen(view);

return