function dims = viewSize(view)
%Returns the full size of the view.
% 
% dims = viewSize(view)
%
% Used to transform coordinates from one viewType to another.
%
% For INPLANE, returns     [cropInplaneSize,nSlices]
% For VOLUME/GRAY, returns [volSize] (loaded from vAnatomy header)
% For FLAT, returns        [imageSize,2]
%

global mrSESSION;
global vANATOMYPATH;

switch view.viewType
    case 'Inplane'
    dims = [mrSESSION.inplanes.cropSize, mrSESSION.inplanes.nSlices];
case {'Volume','Gray','generalGray'}
    if isfield(view, 'anat')
        if ~isempty(view.anat), dims = size(view.anat); end
    end
    if ~exist('dims','var')
        pth = getVAnatomyPath; % assigns it if it's not set
        [mmPerPix, dims] = readVolAnatHeader(pth);
    end
case 'Flat'
    dims = [view.ui.imSize,2];
case 'SS'
    dims = [mrSESSION.inplanes.cropSize];
end

return
