function view=viewMenu(view)
% 
% viewMenu
% 
% Set up the callbacks for the VIEW menu
% 
% djh, 1/98
% rmk, 12/10/98  added 'Find Current ROI' to VOLUME
% ras, 04/25/04  added some INPLANE-specific options, incl
%                viewing montages w/ the overlay on it, and
%                setting the 'underlay' (anatomy image) to 
%                be the mean functional img of the selected 
%                scan, and back to inplanes. (Also commented
%                out the 'view annotation' option, since it
%                never seemed to work?)
% ress, 12/04    added menu items for laminar analysis

global HOMEDIR

viewMenu = uimenu('Label','View','Separator','on');

% Cropped Anatomy callback:
%   view=setDisplayMode(view,'anat');
%   view=refreshScreen(view);
callBackstr=[view.name,'=setDisplayMode(',view.name,',''anat''); ',...
	view.name,'=refreshScreen(',view.name,');'];
uimenu(viewMenu,'Label','Cropped Anatomy','Separator','off',...
    'CallBack',callBackstr);

% Coherence Map callback:
%   view=setDisplayMode(view,'co');
%   view=refreshScreen(view);
callBackstr=[view.name,'=setDisplayMode(',view.name,',''co''); ',...
	view.name,'=refreshScreen(',view.name,');'];
uimenu(viewMenu,'Label','Coherence Map','Separator','on',...
    'CallBack',callBackstr);

% Amplitude Map callback:
%   view=setDisplayMode(view,'amp');
%   view=refreshScreen(view);
callBackstr=[view.name,'=setDisplayMode(',view.name,',''amp''); ',...
	view.name,'=refreshScreen(',view.name,');'];
uimenu(viewMenu,'Label','Amplitude Map','Separator','on',...
    'CallBack',callBackstr);

% Phase Map callback:
%   view=setDisplayMode(view,'ph');
%   view=refreshScreen(view);
callBackstr=[view.name,'=setDisplayMode(',view.name,',''ph''); ',...
	view.name,'=refreshScreen(',view.name,');'];
uimenu(viewMenu,'Label','Phase Map','Separator','on',...
    'CallBack',callBackstr);

% Mean map callback:
%   view=loadMeanMap(view);
%   view=setDisplayMode(view,'map');
%   view=refreshScreen(view);
callBackstr=[view.name,'=loadMeanMap(',view.name,'); ',...
	view.name,'=setDisplayMode(',view.name,',''map''); ',...
	view.name,'=refreshScreen(',view.name,');'];
uimenu(viewMenu,'Label','Mean Map','Separator','on',...
   'CallBack',callBackstr);
 
 % Laminar distance map callback:
 callBackstr = [view.name, ' = DisplayLaminae(', view.name, ');'];
 uimenu(viewMenu, 'Label', 'Laminar distance map', 'Separator', 'on', ...
   'CallBack', callBackstr);

% Residual Std map callback:
%   view=computeStdMap(view);
%   view=setDisplayMode(view,'map');
%   view=refreshScreen(view);
if strcmp(view.viewType,'Inplane')
  callBackstr=[view.name,'=loadResStdMap(',view.name,'); ',...
        view.name,'=setDisplayMode(',view.name,',''map''); ',...
        view.name,'=refreshScreen(',view.name,');'];
  uimenu(viewMenu,'Label','Residual Std Map','Separator','on',...
    'CallBack',callBackstr);
end

% Parameter Map callback:
%   view=setDisplayMode(view,'map');
%   view=refreshScreen(view);
callBackstr=[view.name,'=setDisplayMode(',view.name,',''map''); ',...
	view.name,'=refreshScreen(',view.name,');'];
uimenu(viewMenu,'Label','Parameter Map','Separator','on',...
    'CallBack',callBackstr);

% for inplane views, allow 
if strcmp(view.viewType,'Inplane')
    
    % ----- Anatomy underly sub-menu ----- %
    underlayMenu = uimenu(viewMenu,'Label','Anat Image...','Separator','on');

    % ----- inplane mosaic option ----- %
    % callback: inplaneMosaic(view);
    cbstr = sprintf('inplaneMosaic(%s);',view.name);
    uimenu(underlayMenu,'Label','View All Slices w/ Overlay','Separator','on',...
        'CallBack',cbstr);
    
    % ----- toggle direction labels ----- %
    % callback: view = setInplaneDirLabel(view);
    cbstr = sprintf('%s = setInplaneDirLabel(%s);',view.name,view.name);
    uimenu(underlayMenu,'Label','Set direction labels','Separator','on',...
         'CallBack',cbstr);

    
    % ----- set Anat Underlay UI -------- %
    % callback: view = setUnderlay(view);
    cbstr = sprintf('%s = setUnderlay(%s);',view.name,view.name);
    uimenu(underlayMenu,'Label','Change Underlay...','Separator','on',...
        'CallBack',cbstr);
    
elseif strcmp(view.viewType,'Volume') | strcmp(view.viewType,'Gray')
    % ----- Anatomy underly sub-menu ----- %
    underlayMenu = uimenu(viewMenu,'Label','Anat Image...','Separator','on');

    % ----- flip L/R ----- %
    cbstr = sprintf('%s.ui.flipLR=1; refreshScreen(%s);',view.name,view.name);
    uimenu(underlayMenu, 'Label', 'Radiological L/R', 'Separator', 'on',...
        'CallBack', cbstr);
    
    cbstr = sprintf('%s.ui.flipLR=0; refreshScreen(%s);',view.name,view.name);
    uimenu(underlayMenu,'Label', 'mrVista L/R', 'Separator', 'off',...
        'CallBack', cbstr);
    
    % ----- ROI slice montage ----- %
    uimenu(underlayMenu,'Label','Show ROI Slice Montage','Separator','on',...
        'CallBack','showROISlices;');

end

% Toggle figure menus:
addFigMenuToggle(viewMenu);


% view=refreshScreen(view);
callBackstr=[view.name,'= refreshScreen(',view.name,');'];
uimenu(viewMenu,'Label','Refresh','Separator','on',...
    'CallBack',callBackstr);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Select Slice Coords for Volume view %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

if strcmp(view.viewType,'Volume') | strcmp(view.viewType,'Gray')
  % Select Slice Coords callback:
  %   view=selectSliceCoords(view);
  callBackstr=[view.name,'=selectSliceCoords(',view.name,');'];
  uimenu(viewMenu,'Label','Select Slice Coords','Separator','on',...
      'CallBack',callBackstr);

  % Select Current ROI Slice  callback:
  %   view=selectCurROISlice(view);
  %   view=refreshScreen(view);
  callBackstr=[view.name,'=selectCurROISlice(',view.name,'); ',...
      view.name,'=refreshScreen(',view.name,');'];
  uimenu(viewMenu,'Label','Find Current ROI','Separator','on',...
      'CallBack',callBackstr);
end
	
return
