function temporalNormalization = temporalNormalizationFlag(view,scan,flagValue)
%
%  temporalNormalization = temporalNormalizationFlag(view,scan,flagValue)
%
% Author:  ARW
% Date:  4.14.03
% Purposes:
%    This routine creates the temporal normalization flag inside the
%    dataTYPES argument.  The flag is set to 0 by default (i.e., no
%    normalization). Once the flag exissts, you can also set it to 1.  This
%    causes various routines scale the mean intensity of each slice to be
%    constant over time. 
%
%    This routine mixes get/set.  If the field doesn't exist, we are
%    setting it to the default flagValue.  If the field does exist, we
%    leave it unchanged and return the value.  I am not sure I like that.
%
%    In some cases, (e.g. the Tuebingen data), we need to perform this
%    normalization.  This is called mean intensity adjustment (MIA) in
%    Brain Voyager.
% 
% bw/aab:  Comments and flagValue added.  4.28.03
%          This routine needs to go away and be replaced with a
%          setDataTypes('Value','Parameter') 
%          getDataTypes('Parameter')
%          type routine.
%

global dataTYPES;

if ~exist('scan','var')
    if isfield(view,'ui')
        scan = getCurScan(view);
    else
        scan = 1;
    end
end


if (isfield(dataTYPES(view.curDataType).blockedAnalysisParams(scan),'temporalNormalization')) & ...
        ~isempty(dataTYPES(view.curDataType).blockedAnalysisParams(scan).temporalNormalization) & ...
        ~exist('flagValue','var')
    temporalNormalization = ...
        dataTYPES(view.curDataType).blockedAnalysisParams(scan).temporalNormalization;
    return;
else
    if ~exist('flagValue','var') flagValue = 0; end
    
    dataTYPES(view.curDataType).blockedAnalysisParams(scan).temporalNormalization=flagValue;
    temporalNormalization=flagValue;
end

return;
