function dims = sliceDims(view,scan)
%
% dims = sliceDims(view,[scan])
%
% Returns the size for a single slice of the data array
% i.e., corresponding to a single tSeries file.
%
% scan: required for inplane views, but not used for volumes/grays/flats
%
% For INPLANE, returns [cropTSeriesSize]
% For FLAT, returns [imageSize]
%
% djh, 2/22/2001
% abm, 2006-08-04 some problems arose on implementation on MAC OS X
% concerning the class of the dims returned by this function (they appear to be uint16,
% which should combine with doubles according to the error returned by
% matlab, but they didn't! 
% I guess there must have been some recasting of classes for the
% version/platform combination I am using: 7.1.0.183 (R14) Service Pack 3 on OS X. 

if ieNotDefined('scan')
    scan = getCurScan(view);
end

global dataTYPES;
switch view.viewType
case 'Inplane'
    dims = double([dataTYPES(view.curDataType).scanParams(scan).cropSize]);
case {'Volume','Gray'}
    dims = double([1,size(view.coords,2)]);
case 'Flat'
    dims = double([view.ui.imSize]);
end
return
