function [h, montage] = showROISlices(view);
% [h montage] = showROISlices(view);
%
% make a mosaic image (w/ handle h) of 
% all the slices in the current view that
% contain the selected ROI.
%
% Currently Volume/Gray view specific.
%
% ras 11/22/04.
if ieNotDefined('view')
    view = getSelectedGray;
end

viewType = viewGet(view,'viewType');

if ~isequal(viewType,'Gray') & ~isequal(viewType,'Volume')
    fprintf('Sorry, currently volume/gray specific now...\n');
    return
end

% initialize montage
montage = [];

% get selected roi
rois = viewGet(view,'rois');
selRoi = viewGet(view,'selectedROI');
roi = rois(selRoi);
coords = roi.coords;

% get display mode info from view
displayMode = viewGet(view,'displayMode');
modeInfo = viewGet(view,[displayMode 'Mode']);

% vol view: get cur orientation
ori = getCurSliceOri(view);

% figure out which slices it belongs to, depending on
% orientation
coords = canOri2CurOri(view,coords);
slices = unique(round(coords(3,:)));
nSlices = length(slices);

% figure out montage size
ncols = ceil(sqrt(nSlices));
nrows = ceil(nSlices/ncols);

% create the montage
for row = 1:nrows
    rowim = [];
    for col = 1:ncols
        ind = (row-1)*ncols + col;
        if ind <= nSlices
            [view im] = recompute3ViewImage(view,slices(ind),ori);
                                  
            if isfield(view.ui,'flipLR') & view.ui.flipLR==1 & ori < 3
                im = fliplr(im);
            end
            
            if view.ui.showROIs ~= 0
                % color in ROI locations
                subCoords = coords(1:2,coords(3,:)==slices(ind));
                roiIndices = sub2ind(size(im),subCoords(1,:),subCoords(2,:));
                im(roiIndices) = modeInfo.numGrays + modeInfo.numColors;
            end

            % apply zoom
            if isfield(view.ui,'zoom')
                switch ori
                    case 1, % axial
                        xrng = view.ui.zoom(3,:);
                        yrng = view.ui.zoom(2,:);
                    case 2, % coronal
                        xrng = view.ui.zoom(3,:);
                        yrng = view.ui.zoom(1,:);
                    case 3, % sagittal
                        xrng = view.ui.zoom(2,:);
                        yrng = view.ui.zoom(1,:);
                end
                im = im(yrng(1):yrng(2),xrng(1):xrng(2));
            end
        else
            im = zeros(size(im));
        end
        rowim = [rowim im]; 
    end
    montage = [montage; rowim];
end

% display the image
h = figure;
imshow(montage,modeInfo.cmap);

return