function view = setParameterMap(view,parMap,mname)
%
% view = setParameterMap(view,parMap,[mapName])
%
% Sets the field view.map = parMap, after checking that parMap has the
% correct size.
% sets view.mapName=mapNname;
%
% djh, 12/30/98
% rmk, 1/15/99 added map name parameter
% djh, 4/99.  Added calls to reset the mapWin sliders according
%   to the min/max of the parameter map.
% djh, 7/99.  Updated code that checks the size.  It was only
%   written for the inplane view.
% dbr, 12/99. Fixed single-scan singlet dimension problem.
% djh, 2/22/2001. Changed to cell array.
% ras, 02/04. If there are more scans specified in dataTYPES for this data
% type than exist in the map dir, will just pad it out. Did this b/c I
% often add new averages scans as I extend my analyses; I realize it may
% allow mismatched param maps to go by unnoticed, but figure that's less
% likely.
% ras, 04/04. Also: if any par maps are loaded for other scans, don't
% delete those -- just punch in maps for scans assigned to the parMap.
% ras, 05/04: Made the test more stringent for distinguishing hidden v 
% non-hidden views.

if ~exist('mname');
	mname='';
end

if length(parMap) < numScans(view)
    parMap{numScans(view)} = [];
end
checkSize(view,parMap);

if isfield(view, 'ui') & isfield(view.ui,'windowHandle'); % test for non-hidden view    
    % Find min/max and reset sliders
	minVal = inf;
	maxVal = -inf;
	for iScan = 1:numScans(view)
		if ~isempty(parMap{iScan})
			minVal = min(minVal, min(parMap{iScan}(:)));
			maxVal = max(maxVal, max(parMap{iScan}(:)));
		end
    end
    
    % deal w/ min/max being switched
    if (minVal>maxVal), tmp=maxVal; maxVal=minVal; minVal=tmp; end
    
    % if new min/max are outside current set pts, keep same set pts;
    % otherwise, reset points to minVal & maxVal
    setVals = viewGet(view, 'mapWin');
    setMin = setVals(1); setMax = setVals(2);
%    if setMin < minVal
        setMin = minVal;
%    end 
%    if setMax > maxVal
        setMax = maxVal;
%    end
    
	view = resetSlider(view, view.ui.mapWinMin, minVal, maxVal, setMin);
	view = resetSlider(view, view.ui.mapWinMax, minVal, maxVal, setMax);
end

view.map{numScans(view)} = [];
for s = 1:numScans(view)
    if ~isempty(parMap{s})
		view.map{s} = parMap{s};
        mname(mname=='_') = '-'; % dodge the TeX interpreter :)
		view.mapName = mname;
    end
end

view = setDisplayMode(view, 'map');

return
