function pathStr = roiDir(view,loadFromDefaultFlag)
%
% pathStr = roiDir(view,loadFromDefaultFlag)
%
% djh, 2/2001% ras, 2/2004 -- switched back to absolute specification.
% ras, 8/2004 -- made a local version for KGS lab in the
% 3Danat directory, with vAnatomies...
%
% ARW 10/07/05: Trying something else. If you pass in loadFromDefaultFlag
% this function will check the value of the global preference
% VISTA.defaultROIPath
% If it exists, it will return a path based on the subject name, the default anatomy path and this rather than the session-specific ROI
% dir.
% It's only valid if view is a VOLUME type
% You will need to add a directory structure to your anatomy/subjectDir directory.
% For example
% x:\anatomy\[subjectname]\Standard\Gray\ROIs
% Then in matlab do
% setpref('VISTA','defaultROIpath','\Standard\Gray\ROIs');
% Possibly we could set this default dir on a session-by-session basis
% later.


global mrSESSION HOMEDIR

if (ieNotDefined('loadFromDefaultFlag'))
    loadFromDefaultFlag=0;
end

if (loadFromDefaultFlag)
    
    disp('Attempting to load default ROIs');

    if ((strcmp(view.viewType,'Gray') | strcmp(view.viewType,'Volume')))
        if (ispref('VISTA','defaultROIPath'))
            ROIdir=getpref('VISTA','defaultROIPath');
            pathStr=[getAnatomyPath,filesep,ROIdir];
            disp(pathStr);
            return
        else
            disp('Default anatomy and ROI paths not set. Try setpref(''VISTA'',''defaultROIPath'',''[somePathName]''');
            pathStr=[];
            return;
        end % End check on preference existing
    else % This is not a Volume-type view. 

        disp('You cannot use a default (session-independent) ROI directory for a non-volume-type view');
        pathStr=[];
        return;

    end % End check on view type
end % End check on flag


% if isequal(view.viewType,'Gray') | isequal(view.viewType,'Flat')
%     pathStr = fullfile(HOMEDIR,'anat',[view.viewType 'ROIs']);
% else
    pathStr = fullfile(HOMEDIR,view.subdir,'ROIs');
% end

% make it if it's not there
%
%disp(pathStr);


if ~exist(pathStr,'dir')
    fprintf('Making ROI dir %s ...\n',pathStr);
    callingDir = pwd;
    [a b] = fileparts(pathStr);
    cd(a);
    mkdir(b);
    cd(callingDir);
end

return;