function view=resetDisplayModes(view,numGrays,numColors)
%
% view=resetDisplayModes(view)
%
% Initializes/resets displayModes and colormaps for each of the
% possible displayModes.  See refreshScreen.
%
% djh, 1/98
% ras, 09/04 -- added option to up the # of grays/colors, 
% trying to move towards using truecolor images

if nargin < 2
    numGrays=128;
end
if nargin < 3
   numColors=128;
end

view.ui.anatMode.clipMode = 'auto';
view.ui.anatMode.numGrays = numGrays;
view.ui.anatMode.numColors = numColors;
view.ui.anatMode = setColormap(view.ui.anatMode,'grayCmap');

view.ui.coMode.clipMode = [0 1];
view.ui.coMode.numGrays = numGrays;
view.ui.coMode.numColors = numColors;
view.ui.coMode = setColormap(view.ui.coMode,'redGreenCmap');

view.ui.ampMode.clipMode = 'auto';
view.ui.ampMode.numGrays = numGrays;
view.ui.ampMode.numColors = numColors;
view.ui.ampMode = setColormap(view.ui.ampMode,'hotCmap');

view.ui.phMode.clipMode = [0 2*pi];
view.ui.phMode.numGrays = numGrays;
view.ui.phMode.numColors = numColors;
view.ui.phMode = setColormap(view.ui.phMode,'hsvCmap');

view.ui.mapMode.clipMode = 'auto';
view.ui.mapMode.numGrays = numGrays;
view.ui.mapMode.numColors = numColors;
view.ui.mapMode = setColormap(view.ui.mapMode,'hotCmap');

return
