function view = renderCrosshairs(view, on, method, color);
% 
% view = renderCrosshairs(view, <on, method, color>);
%
% Draw crosshairs on a mrVista window (currently only volume / gray
% 3-view, maybe we can generalize). Deletes any existing xhair lines.
%
% on: flag for whether to draw the crosshairs at the current location
% or just delete the old ones. <default: 1, draw them>
%
% method: flag for what method to use when drawing. Current options:
%   1: draw two intersecting lines.
%   2: draw lines with a gap between.
%   <default: check for preferred method, or else 1>
% 
% color: color ([R G B] triplet or single character) to use for the
% xhairs. <default: check for preferred color, or else [1 .5 .5]>
%
% 02/06 by ras. Different drawing methods Not Yet Implemented
if ~exist('on','var') | isempty(on), on = 1; end

if ~exist('method','var') | isempty(method)
    if ispref('VISTA', 'xHairMethod')
        method = getpref('VISTA', 'xHairMethod')
    else
        method = 1;
    end
end

if ~exist('color','var') | isempty(color)        
    if ispref('VISTA','xHairColor')
        color = getpref('VISTA','xHairColor');
    else
        color = [1 0.5 0.5];
    end
end

ui = view.ui; loc = view.loc;

%%%%%delete any existing lines
delete(findobj('Tag', 'xHairs'));

if on==1
    %%%%%draw the lines
    if isfield(ui,'flipLR') & ui.flipLR==1
        axes(ui.axiAxesHandle);
        l(1) = line(size(view.anat,3)-[loc(3) loc(3)], [1 size(view.anat,2)]);
        l(2) = line([1 size(view.anat,3)], [loc(2) loc(2)]);
        axes(ui.corAxesHandle);
        l(3) = line(size(view.anat,3)-[loc(3) loc(3)], [1 size(view.anat,1)]);
        l(4) = line([1 size(view.anat,3)], [loc(1) loc(1)]);
    else
        axes(ui.axiAxesHandle);
        l(1) = line([loc(3) loc(3)], [1 size(view.anat,2)]);
        l(2) = line([1 size(view.anat,3)], [loc(2) loc(2)]);
        axes(ui.corAxesHandle);
        l(3) = line([loc(3) loc(3)], [1 size(view.anat,1)]);
        l(4) = line([1 size(view.anat,3)], [loc(1) loc(1)]);
    end

    if isfield(ui,'flipAP') & ui.flipAP==1
        axes(ui.sagAxesHandle);
        l(5) = line(size(view.anat,2)-[loc(2) loc(2)], [1 size(view.anat,1)]);
        l(6) = line([1 size(view.anat,2)], [loc(1) loc(1)]);
    else
        axes(ui.sagAxesHandle);
        l(5) = line([loc(2) loc(2)], [1 size(view.anat,1)]);
        l(6) = line([1 size(view.anat,2)], [loc(1) loc(1)]);
    end
    
    set(l, 'Color', color, 'Tag', 'xHairs');    
else
    l = [];
end

view.ui.xHairHandles = l;

return
