function view = refreshScreen(view,varargin)
%
% view = refreshScreen(view,[optional args])
%
% Calls view.refreshFn to refresh the window with up to 5
% optional arguments.
%
% djh, 8/98
%

% Programming notes
% BW -- This needs to be re-written or go away.  Should use varargin.  Not
% entirely clear why we need this on top of refreshScreen.
% RAS -- The new views I've made (inplane montage, 3-way views, etc)
% use refresh functions other than 'refreshView'. So refreshScreen
% is a little nicer than refreshView. I've cleaned up the optional
% input args, not sure if anyone actually uses those, but it's good
% to have around.
mrGlobals;

if ~exist('view', 'var') | isempty(view)
    view = getSelectedInplane;
end

if ~isfield(view, 'refreshFn'), return; end

% before evaluating the refresh function, update the global variable
% corresponding to the view name -- a lot of little bugs seem to 
% occur when this doesn't happen, b/c some fields only get set
% locally but not globally (another reason why global variables are
% not a great idea down the line). -ras, 01/06
assignin('base', 'TMP', view);
evalin('base', sprintf('%s = TMP;', view.name));
evalin('base', 'clear TMP');

if isempty(varargin)
    % no optional arguments
    cmd = sprintf('%s = %s(%s);', view.name, view.refreshFn, view.name);
else
    % add optional arguments
    cmd = sprintf('%s = %s(%s', view.name, view.refreshFn, view.name);
    for i = 1:length(varargin)
        if isnumeric(varargin{i})
            cmd = sprintf('%s,[%s]',cmd,num2str(varargin{i}));
        else
            cmd = sprintf('%s,%s',cmd,varargin{i});
        end            
    end
    cmd = sprintf('%s);',cmd);
end

evalin('base', cmd);

return

