function view = makeTSeriesMovie(view,scan,slice,anatFlag,thresh)
% 
% view = makeTSeriesMovie(view,[scan],[slice],[anatFlag],[thresh])
%
% Makes movie of tSeries for current scan and slice and sets the field
% view.ui.movie. Use showTSeriesMovie to reshow a movie that has already
% been created. The view.ui.movie field is cleared by recomputeImage which
% is called when you change scans, slices, or viewTypes.
%
% anatFlag: superimpose functional movie in pseudo-color on the 
% inplane anatomy.
%
% djh, 12/30/98
% ras, 05/01/04: turned off 'true size' option for the 
% figure and made the fig size reasonably large.

if ~strcmp(view.viewType,'Inplane')
    myErrorDlg('makeFunctionalMovie: only for inplane views');
end

if ~exist('scan','var') | isempty(scan)
    scan = getCurScan(view);
end
if ~exist('slice','var') | isempty(slice)
    slice = getCurSlice(view);
elseif slice == 0
    slice = sliceList(view, scan);
end
if ~exist('anatFlag','var')  | isempty(anatFlag)
    anatFlag = 0;
end
if ~exist('thresh','var') | isempty(thresh)
    thresh = 180;
end

% Initialize movie
view.ui.movie = [];
view.ui.movie.scan = scan;
view.ui.movie.slice = slice;

% Initialize figure
selectGraphWin; clf
% set(gcf,'Units','Normalized','Position',[.1 .1 .5 .5]);
set(gcf,'Name',['tSeries movie, scan ',num2str(scan),', slice ',num2str(slice)]);
%whitebg(gcf,[0 0 0]);
set(gcf,'DefaultTextColor','yellow');
set(gca,'Position',[0 0 1 1]);
if(anatFlag & isempty(view.anat))
    view = loadAnat(view);
end
for(ii=1:length(slice))
    % Load tSeries
    tSeriesAll{ii} = loadtSeries(view,scan,slice(ii));
end
histThresh = length(reshape([tSeriesAll{:}],1,[]))/1000;
[tsCnt, tsVal] = hist(reshape([tSeriesAll{:}],1,[]),100);
minval = tsVal(min(find(tsCnt>histThresh)));
maxval = tsVal(max(find(tsCnt>histThresh)));

dims = sliceDims(view,scan);
nFrames = numFrames(view,scan);

if anatFlag
    % Create a split colormap (0-127 = greyscale, 128-255 = hot)
    cmap = [repmat([0:1/127:1]',1,3); hot(128)];
    colormap(cmap);
    % Get anatomy image
    %anatIm = cropCurAnatSlice(view);
    anatIm = makeMontage(view.anat, slice);
    % Rescale anatIm
    anatIm = rescale2(anatIm,[min(anatIm(:)),max(anatIm(:))],[0,127]);
    image(uint8(anatIm));
    axis image; axis off;
    %view.ui.movie.movie = moviein(nFrames);
    for f = 1:nFrames
        clear tSeries;
        for(ii=1:length(slice))
            tSeries(:,:,ii) = reshape(tSeriesAll{ii}(f,:),dims);
        end
        tSeries = makeMontage(tSeries);
        overlay = upSampleRep(tSeries,size(anatIm));
        overlay = rescale2(overlay,[minval,maxval],[128,255]);
        anatMask = overlay < thresh;
        im = overlay.*~anatMask + anatIm.*anatMask;
        image(uint8(im));
        axis image; axis off;
        text(10,10,num2str(f));
        view.ui.movie.movie(f) = getframe;
    end
else
    colormap(gray(256));
    %im = uint8(rescale2(reshape(tSeries(1,:),dims),[minval,maxval],[0,255]));
    %image(im);
    axis image; axis off;
    view.ui.movie.movie = moviein(nFrames);
    for f = 1:nFrames
        clear tSeries;
        for(ii=1:length(slice))
            tSeries(:,:,ii) = reshape(tSeriesAll{ii}(f,:),dims);
        end
        tSeries = makeMontage(tSeries);
        im = rescale2(tSeries,[minval,maxval],[0,255]);
        image(uint8(im));
        axis image; axis off; truesize;
        text(10,10,num2str(f));
        view.ui.movie.movie(f) = getframe;
    end
end

return