function view = initHiddenGray(dataType,scan,roi);
%
% function hiddenGray = initHiddenGray([dataType],[scan],[roi])
%
% djh, sometime in 1999
% ras, 04/05, set name to 'hidden'
% ras, 05/05, added 'curScan' field
% ras, 09/05, ensures session is loaded, 
% mrGlobals is run; can specify data type,
% scan, and roi at outset.
if ~exist('dataType','var') | isempty(dataType)
    dataType = 1;
end

if ~exist('scan','var') | isempty(scan)
    scan = 1;
end

evalin('base','mrGlobals');
evalin('base','loadSession');
evalin('base','HOMEDIR = pwd;');

disp('Initializing HIDDEN Gray view')

view.name='hidden';
view.viewType='Gray';
view.subdir='Gray';

% Initialize slots for co, amp, and ph
view.co = [];
view.amp = [];
view.ph = [];
view.map = [];
view.mapName = '';

% Initialize ROIs
view.ROIs = [];
view.selectedROI = 0;

% Initialize curDataType
if isnumeric(dataType),
    view.curDataType = dataType;
elseif ischar(dataType),
    view.curDataType = existDataType(dataType);
end

% Initialize curScan
view.curScan = scan;

% Compute/load coords
view=switch2Gray(view);

% let's be memory-efficient
view.coords = int16(view.coords);
view.nodes = view.nodes;
view.edges = view.edges;
view.allLeftNodes = view.allLeftNodes;
view.allLeftEdges = view.allLeftEdges;
view.inplaneLeftIndices = view.inplaneLeftIndices;
view.allRightNodes = view.allRightNodes;
view.allRightEdges = view.allRightEdges;
view.inplaneRightIndices = view.inplaneRightIndices;

% load any ROIs specified
if exist('roi','var') & ~isempty(roi)
    view = loadROI(view,roi);
end


return
