function gray = getSelectedGray
%
% gray = getSelectedGray
%
%Purpose:
% Returns the currently selected gray view.
% If no gray view is selected, returns the last (presumably
% most recent) gray view.
% ARW 081203 - Added default gray return.
% ras 092605 - made it return the most recent gray if there are more than
% one; I figure this is right enough times that it's better than erroring.
mrGlobals
if ieNotDefined('VOLUME')
    warning('No selected Gray: VOLUME variable is not defined.');
    gray = [];
    return
end

if ~isempty(selectedVOLUME) & strcmp(VOLUME{selectedVOLUME}.viewType,'Gray')
    gray = VOLUME{selectedVOLUME};
else
    grayList=cellfind(VOLUME);
    gray = VOLUME{grayList(end)};
%     if ((length(grayList)==1))
%         selectedGRAY=grayList;
%         gray=VOLUME{selectedGRAY};
%     else
%         gray = [];
%     end
end


return;
