function smoothFrames = detrendFrames(view,scan)
%
% detrend = detrendFrames(view,[scan])
%
% Switches off dataType depending on blockedAnalysis vs eventAnalysis
%
% djh, 2/21/2001
% ras, 2004: changed priority to set event analysis params over 
% blocked params (keeping this in my local version for now).

global dataTYPES;

if ~exist('scan','var')
    if isfield(view,'ui')
        scan = getCurScan(view);
    else
        scan = 1;
    end
end

if (dataTYPES(view.curDataType).blockedAnalysisParams(scan).blockedAnalysis)
    nCycles = numCycles(view,scan); disp(nCycles)
    nFrames = numFrames(view,scan); disp(nFrames)
    smoothFrames = ceil(nFrames / nCycles);
elseif (dataTYPES(view.curDataType).eventAnalysisParams(scan).eventAnalysis)
    smoothFrames = dataTYPES(view.curDataType).eventAnalysisParams(scan).detrendFrames;
end        

return