function dims = dataSize(view,scan)
%
% dims = dataSize(view,[scan])
% 
% Returns the size of the data arrays, i.e., size of co for
% a single scan.
%
% scan: required for inplane views, but not used for volumes/grays/flats
%
% For INPLANE, returns [cropTSeriesSize,nSlices]
% For VOLUME/GRAY, returns size(view.coords)
% For FLAT, returns [imageSize,2]
%
% djh, 2/22/2001
if ~exist('scan','var') | isempty(scan), scan = getCurScan(view); end

switch view.viewType
    case 'Inplane'
        dims = [sliceDims(view,scan) numSlices(view)];
    case {'Volume','Gray'}
        dims = [1,size(view.coords,2)];
    case 'Flat'
        dims = [view.ui.imSize,numSlices(view)];
end

return
