function slice = cropCurSlice(view, field, curSlice, orientation)
%
% function slice = cropCurSlice(view, field, curSlice, orientation)
%
% Pulls slice from view.field.  Field can be co, amp, ph, or
% map.
%
% djh, 7/98
% ras, 3/03: allows orientation/slicenum to be entered as arguments (to be
% compatible with multi-view option for volume and gray views).
global mrSESSION

% Get curSlice, curScan from buttons
% (unless entered)
if ~exist('curSlice','var') | isempty(curSlice),
    curSlice = getCurSlice(view);
end
curScan = getCurScan(view);

if ~isfield(view, field) 
    myErrorDlg(['Invalid display mode: ',field]);
end

% Pull out data corresponding to field.
data = view.(field);

if isempty(data)
    slice=[];
    return
end

% pull out curScan:
% bounds check: if the data haven't been computed for this
% scan (or if a new scan was added to the data type, e.g.
% in Averages), don't error, but warn and return an empty slice:
if length(data) < curScan | isempty(data{curScan})
    slice=[];
    return
else
    dataScan = data{curScan};
end

switch view.viewType
case 'Flat'
    % pull out curSlice
    slice = dataScan(:,:,curSlice);
    
case 'Inplane'
    % pull out curSlice
    slice = dataScan(:,:,curSlice);
    % interpolate up to the size of the anatomy image
    slice = upSampleRep(slice,mrSESSION.inplanes.cropSize);
    
case {'Volume','Gray'}
    % Get slice orientation
    if ~exist('orientation','var')  
        orientation = getCurSliceOri(view);
    end
    
    % Find indices of the appropriate VOLUME.coords, make the image,
    % and a 2xN array of image coordinates (where N is the
    % number of VOLUME.coords in the slice).
    volSize = viewSize(view);
    
    switch orientation
    case 1 
        % axial (x-z) slice
        indices = find(view.coords(1,:)==curSlice);
        imSize = volSize([2,3]);
        imCoords = double(view.coords([2,3],indices));
    case 2 
        % coronal (y-z) slice				
        indices = find(view.coords(2,:)==curSlice);
        imSize = [volSize([1,3])];
        imCoords = double(view.coords([1,3],indices));
    case 3 
        % sagittal (y-x) slice				
        indices = find(view.coords(3,:)==curSlice);
        imSize = volSize([1,2]);
        imCoords = double(view.coords([1,2],indices));
    end
    
    dataScanSlice = dataScan(indices);
    
    % Make an image of the appropriate size.
    slice = zeros(imSize);
    
    % Compute the image indices from the image coordinates
    imIndices = coords2Indices(imCoords,imSize);
    
    % Set those image values from the data
    slice(imIndices) = dataScan(indices);
end

return

