function view = callTSeriesMovie(view);
% view = callTSeriesMovie(view);
%
% Simple dialog for setting params to call tSeriesMovie.
%
% 12/16/04 ras.
% 03/30/05 ras: loads the movie object into the view's ui.movie field,
% in lieu of the old matlab struct.
% 01/06/05 ras: added field for comparison frame.
prompt={'Scans:' ...
        'Use Anat Image? (1 for yes, 0 for no):' ...
        'Clip values for functionals [min max]:' ...
        'Compare to a reference frame? (0 if no, else input frame #)' ...
        'Convert to % Signal? (1 for yes, 0 for no):' ...
        'Movie Frames per Second?' ...
        'Save as .AVI file? [Enter Path to export, or ''1'' for dialog]:' ...
        };
def={num2str(getCurScan(view)) ...
        '0' ...
        '[0.2 1]' ...
        '0' ...
        '0' ...
        '24' ...
        ''
    };
dlgTitle='Make Movie of tSeries w/ UI';
answer=inputdlg(prompt,dlgTitle,1,def);
% if 'cancel' pressed, exit gracefully
if isempty(answer)
    return
end

% parse responses
scans = str2num(answer{1});
anatFlag = str2num(answer{2});
funcClip = str2num(answer{3});
compareFrames = str2num(answer{4});
convertToPct = str2num(answer{5});
fps = str2num(answer{6});
aviFlag = answer{7};
if anatFlag==1
    applyHisto = 1;
else
    applyHisto = 0;
end
if convertToPct==1
    meanThresh = funcClip(1);
else
    meanThresh = 0;
end

if isequal(aviFlag,'1')
    aviPath = 'dialog';
elseif isequal(aviFlag,'0') | isempty(aviFlag)
    aviPath = '';
else 
    aviPath = aviFlag;
end

% call movie
[M view.ui.movie] = tSeriesMovie(view, scans, anatFlag,...
                         'funcClip', funcClip,...
                         'convertToPct', convertToPct,...
                         'applyHisto', applyHisto,...
                         'compareFrames', compareFrames, ...
                         'meanThresh', meanThresh,...
                         'saveAvi', aviPath,...
                         'fps', fps);
return
