function view = UpdateMapWindow(view)
%
% view = UpdateMapWindow
%
% Sets the MapWindow sliders to correspond to current parameter map (if any
% is present).
%
% Ress, 6/03
% ras, 11/04 -- doesn't always throw out the prev. set points

if isempty(view.map), return, end

parMap = viewGet(view,'map');

if isfield(view, 'ui') & isfield(view.ui,'windowHandle'); % test for non-hidden view    
    % Find min/max and reset sliders
	minVal = inf;
	maxVal = -inf;
	for iScan = 1:numScans(view)
		if ~isempty(parMap{iScan})
			minVal = min(minVal,min(parMap{iScan}(:)));
			maxVal = max(maxVal,max(parMap{iScan}(:)));
		end
	end
    
    % if new min/max are outside current set pts, keep same set pts;
    % otherwise, reset points to minVal & maxVal
    setVals = viewGet(view,'mapWin');
    setMin = setVals(1); setMax = setVals(2);
    if setMin < minVal
        setMin = minVal;
    end
%     if setMax > maxVal
        setMax = maxVal;
%     end
    
	view = resetSlider(view,view.ui.mapWinMin,minVal,maxVal,setMin);
	view = resetSlider(view,view.ui.mapWinMax,minVal,maxVal,setMax);
end

return