function view = selectDataType(view,n)
%
% view = selectDataType(view,n)
%
% Selects the Nth dataType in mrSESSION.dataTypes to be the current dataType. 
% - Sets view.curDataType=n;
% - Blasts co, amp, ph, & map
% - Resets the dataType popup and the scan slider
% You can also enter the name of the data type.
%
% djh, 1/26/98
% ras, 01/05: also now allows you to select by name.
global dataTYPES
global mrSESSION
global INPLANE
global VOLUME
global FLAT

if ischar(n)
    % find the # of the data type w/ that name
    % mrGlobals;
    names = {dataTYPES.name};
    tmp = cellfind(names,n);
    
    % warn, but do nothing, if the
    % specified name wasn't found:
    if isempty(tmp)
        msg = sprintf('No Data type found with name %s. Making no changes...',n);
        warning(msg);
        return
    else
        n = tmp;
    end
end
    
if view.curDataType ~= n
    view.curDataType = n;
    view = clearData(view);
end

% Set popup slider
if isfield(view,'ui')
    setDataTypePopup(view);
    view = initScanSlider(view);
end

% we'll want to update the global view variable in the base workspace, 
% as well, or else the change might be forgotten:
assignin('base', 'TMP', view);
cmd = sprintf('%s = TMP; clear TMP; ', view.name);
evalin('base', cmd);

return
