function removeDataType(dataTypeIndex);
%
%     removeDataType(dataTypeName);
% 
% Remove a dataType from mrSESSION and updates open views appropriately.
% This routine depends on dataTYPES being a global variable.
%
% djh, 3/2001

mrGlobals

if strcmp(dataTypeName,'Original')
    fprintf('removeDataType: Cannot remove original dataType.\n');
    break;
end

ndataType = existDataType(dataTypeName);

% If the dataType exists, (1) remove it from mrSESSION, (2) remove it from the
% popup menu options, (3) adjust the value of the curDataType
% and (4) check whether or not to delete the corresponding subdirectories
if ndataType
    % Adjust the mrSESSION structure
    fprintf('removeDataType: removing %s dataType\n',dataTypeName);
    dataTYPES(ndataType) = [];
    saveSession(1);
    
    % Delete all the data files for this dataType
    cleanDataType(dataTypeName,1);

    % Loop through the open views, switch their curDataType appropriately, 
    % and update the dataType popups
    INPLANE = resetDataTypes(INPLANE,ndataType);
    VOLUME = resetDataTypes(VOLUME,ndataType);
    FLAT = resetDataTypes(FLAT,ndataType);
else
    fprintf('removeDataType: %s dataType not found.\n',dataTypeName);
end

return;

function viewList=resetDataTypes(viewList,ndataType)

% Loops through the views, changing the dataType appropriately.
% The call to selectDataType updates the dataType popup.
for s=1:length(viewList)
    if ~isempty(viewList{s}) 
        curDataType = viewList{s}.curDataType;
        if curDataType < ndataType
            viewList{s} = selectDataType(viewList{s},curDataType); 
        elseif curDataType >= ndataType
            sel = max(1,curDataType-1);
            viewList{s} = selectDataType(viewList{s},sel); 
        end
    end
end

return