function cleanDataType(dataTypeName,query)
%
%  cleanDataType(dataTypeName,[query])
%
% Deletes:
%   Inplane/dataType/*.mat
%   Inplane/dataType/TSeries/Scan*/*.mat
%   Likewise for Volume, Gray, and Flat*
%
% If you change this function make parallel changes in:
%     cleanGray, cleanFlat
%
% djh, 2/2001
% We could remove the directory for that data type, too.  Maybe we should.
global HOMEDIR
if ~exist('query','var')
    query=0;
end
if query
    but = questdlg(['Delete all data files (corAnal, parameter maps, tSeries) for dataType: ',dataTypeName,'?']);
else
    but = 'Yes';
end
if strcmp(but,'Yes')
    disp(['Deleting all data files (corAnal, parameter maps, tSeries) for dataType: ',dataTypeName]);
    [nDirs,dirList] = countDirs(fullfile(HOMEDIR,'Flat*'));
    dirList{nDirs+1} = 'Inplane';
    dirList{nDirs+2} = 'Gray';
    dirList{nDirs+3} = 'Volume';

    for d=1:nDirs+3
        datadir = fullfile(HOMEDIR,dirList{d},dataTypeName);
        if exist(datadir,'dir')
            delete(fullfile(datadir,'*.mat'));
            [nscans,scanDirList] = countDirs(fullfile(datadir,'TSeries','Scan*'));
            for s=1:nscans
                delete(fullfile(datadir,'TSeries',scanDirList{s},'*.mat'));
            end
        end
    end
end
