function checkTypes(view1, view2)
%
%  checkTypes(view1, view2)
%
% Check if two views are set to the same data type. Error if 
% incompatible types. Useful before transforming ROIs/maps/corAnals/
% tSeries between view types.
%
% djh, 2/23/2001
% ras, 08/04: now gives the option of setting view1 to have 
% the same data type as view 2.
% ras, 02/06: really works now. :)
dt1 = viewGet(view1, 'curdt');
dt2 = viewGet(view2, 'curdt');
if dt1 ~= dt2
    global dataTYPES;
    dt1Name = dataTYPES(dt1).name;
    dt2Name = dataTYPES(dt2).name;
	msg = sprintf('%s and %s are set to different data types.',view1.name,view2.name);
    ch1 = sprintf('Set %s to %s data type',view1.name,dt2Name);
    ch2 = sprintf('Set %s to %s data type',view2.name,dt1Name);
    ch3 = 'Cancel';
    choice = menu(msg,ch1,ch2,ch3);
    switch choice
        case 1, 
            cmd = sprintf('%s = selectDataType(%s, %i);', ...
                            view1.name, view1.name, dt2);
            evalin('base', cmd);
        case 2,
            cmd = sprintf('%s = selectDataType(%s, %i);', ...
                            view2.name, view2.name, dt1);
            evalin('base', cmd);
        otherwise,
            error('Incompatible data types.');
    end
end


return;
