function plotTable(table);
% plotTable(table): display a text
% table in a set of axes.
%
%
% 08/04 ras.

nrows = size(table,1);
ncols = size(table,2);

% ensure table is a cell-of-strings
for row = 1:nrows
    for col = 1:ncols
        if ~ischar(table{row,col})
            table{row,col} = num2str(table{row,col});
        end
    end
end       

% count the text width of each cell, get column 
% width
for col = 1:ncols
    for row = 1:nrows
        sz(row,col) = length(table(row,col));
    end
    
    width(1,col) = max(sz(:,col))+4;
end
xpos = cumsum(width);

% set axes
cla;
AX = [1 sum(width)+3 1 nrows+3];
axis(AX);
set(gca,'XTick',[],'YTick',[],'Box','on');

% plot the text
for row = 1:nrows
    for col = 1:ncols
        X = xpos(col)-2;
        Y = nrows-row+2;
        text(X,Y,table{row,col});
    end
end

return