function view=read4dAnalyzeToTseries(view,inFile,scan,volsToSkip,flipLRflag,timesRot90,flipSliceOrder)

% view=read4dAnalyzeToTseries(view,inFile,scan,volsToSkip,flipLR,timesRot90,flipSliceOrder)
%
% reads in a 4d analyze file and writes TSeries for MRL
% Uses read_avw to read in 4d analyze files. Then saves out the block as
% mlr TSeries while skipping over any initial 'junk frames';
% The roatations and flip are executed in the order of the arguments
% The NumOfRota param allows to you rotate the functional data by doRotate*90 degrees
% timesRot90=1 90� counterclockwise
% timesRot90=2 180� counterclockwise
% timesRot90=3 means 90� clockwise
% a flipUpDown can be performed by timesRot90 and flipLR
%
% 2006.03.20 Mark Schira wrote it 


if (~exist('volsToSkip','var'))
    volsToSkip=0;
end

if (~exist('timesRot90','var'))
    timesRot90=0; % This is off by default. 
end

if (~exist('flipLRflag','var'))
    flipLRflag=0; % This is off by default. Flips left/right after rotation
end

if (~exist('flipSliceOrder','var'))
    flipSliceOrder=0; % This is off by default. Flips left/right after rotation
end

% Reading a large 4-D file can cause memory problems, so we can read the
% file in chunks to remove the problem.  The tSeries are saved to files for
% each slice, so reading slices from the 4-D file is the ways to go.

% 1. Read header to get dimensions


[dims,scales,bpp,endian,datatype] = read_avw_hdr(infile);
y = dims(1); x = dims(2); nSlices = dims(3); nVols = dims(4);



fp=fopen(infile,'r',endian);
for j = 1:nSlices
    tSeries = [];
    for i = 1:nVols
        if (datatype==4),
            fseek(fp, 2 * (x * y * nSlices * (i-1)  +  (j-1) * x * y), 'bof');
            dat=fread(fp, x*y, 'short');
        elseif (datatype==2),
            fseek(fp, 1 * (x * y * nSlices * (i-1)  +  (j-1) * x * y), 'bof');
            dat=fread(fp, x*y,'char');
        elseif (datatype==8),
            fseek(fp, 4 * (x * y * nSlices * (i-1)  +  (j-1) * x * y), 'bof');
            dat=fread(fp,'int');
        elseif (datatype==64),
            fseek(fp, 8 * (x * y * nSlices * (i-1)  +  (j-1) * x * y), 'bof');
            dat=fread(fp,x*y,'double');
        elseif (datatype==16),
            fseek(fp, 4 * (x * y * nSlices * (i-1)  +  (j-1) * x * y), 'bof');
            dat=fread(fp,x*y,'float32');
        end
        %FlipLR
        if flipLRflag 
            dat = reshape(dat,x,y); %need to check the orientations here
            %funcVol(:,:,thisSlice,thisVol)=flipLR(squeeze(funcVol(:,:,thisSlice,thisVol)));
            dat = flipLR(dat);
            dat = reshape(dat,1,x*y);
        end
        %rotate 
        if timesRot90>0
             dat = reshape(dat,x,y);
             %funcVol(:,:,thisSlice,thisVol)=rot90(squeeze(funcVol(:,:,thisSlice,thisVol)),timesRot90);
             dat = rot90(dat);
             dat = reshape(dat,1,x*y);
        end
        
        tSeries = [tSeries; dat];
     
    end 
    %save out the tSeries
    saveTSeries(tSeries,view,scan,t);
end

fclose(fp);


% [y x nSlices nVols]=size(funcVol);
% disp(inFile); disp('This is the size of the functional volume '); disp(size(funcVol))
% 2. choose the slice and read data

% 3. handle orientation flags

% 4. gather the data into a timeseries


% Now write them out in a different format
% fprintf('\nDone reading data: Writing now...\n');
% if flipSliceOrder
%     for t=1:nSlices
% 
%         tSeries=squeeze(funcVol(:,:,nSlices-t+1,:));
%        
%         tSeries=reshape(tSeries,x*y,nVols);
%         disp(size(tSeries));
%         tSeries=tSeries';
%         saveTSeries(tSeries,view,scan,t);
% 
%         fprintf('_');
%     end
% else
%     for t=1:nSlices
%         disp(t)
%         tSeries=squeeze(funcVol(:,:,t,:));
%          disp('Cropped out tSeries data with following dimensions '); disp(size(tSeries));
%         tSeries=reshape(tSeries,x*y,nVols);
%          disp('Reshaped the tSeries data to the follwoing dimensions for writing to file '); disp(size(tSeries)); 
%          %disp(scan);disp(view)
%         tSeries=tSeries';
%         saveTSeries(tSeries,view,scan,t);
% 
%         fprintf('_');
%     end
% end
% 
% fprintf('\nDone\n');
% disp(' ');disp(' ');

