% PennMakeVAnatomy
%
% This script makes a vAnatomy.dat file, starting with the data
% as we get it at Penn.
%
% 6/16/03  dhb  Wrote it.

% Clean out anything that is hanging around.
clear all;

% Prompt user for parameter file. This must live in the current directory.
defaultParameterFilename = 'mrVAnatomyParams';
parameterFilename = input(sprintf('Enter parameter filename [%s]: ',defaultParameterFilename),'s');
if (isempty(parameterFilename))
    parameterFilename = defaultParameterFilename;
end

% Check that the parameter file exists in pwd.  Exit with error if not.
if (~exist(parameterFilename,'file'))
    error(sprintf('Specified parameter file %s\n\tdoes not exist in current directory %s\n',...
        parameterFilename,pwd));
end

% Run the parameter file to set up the variables
eval([parameterFilename]);
nScans = length(sourceSubDirArray);

% CONVERTRAWTOCUB: 
% Use VoxBo tools to convert raw data to .cub format.
% We could process the dicoms directly in MATLAB, but the VoxBo routines
% are much faster.  The VoxBo routine vbrename is useful to run first,
% to sort the dicom files into separate sensible directories.
if (CONVERTRAWTOCUB)
    for i = 1:nScans
        rawDir = fullfile(sourceSubDirArray{i},rawDataDirs{i});
        cubFile = fullfile(sourceSubDirArray{i},cubFiles{i});
        eval(['!vb2cub ' rawDir ' ' cubFile]);
    end
end

% CONVERTCUBTOANALYZE
% Produce Analyze format files.  We use a combination of VoxBo and
% SPM routines to end up with little endian Analyze.
%
% If VoxBo learns to write little endian we can shorten this code.
% Also, here we force loadAnalyze to use a scale factor of 1, which
% handles VoxBo header bug.  If this gets fixed we can just use the
% factor from the image.
if (CONVERTCUBTOANALYZE)
    for i = 1:nScans
        cubFile = fullfile(sourceSubDirArray{i},cubFiles{i});
        analyzeFileBig = fullfile(sourceSubDirArray{i},analyzeFilesBig{i});
        analyzeFileLittle = fullfile(sourceSubDirArray{i},analyzeFilesLittle{i});
        eval(['!vb2img ' cubFile ' ' analyzeFileBig]);
        [img,mmPerVox,hdr] = loadAnalyze(analyzeFileBig,'ieee-be',0,1);
        saveAnalyze(img,analyzeFileLittle,mmPerVox);
    end
end

% Now make mrLoadRet directory.  If it is already
% there, check before overwrite.  The overwrite completely
% clears what whas there before.
if (exist(mrAnatomyDirName,'dir'))
    while (1)
        overwrite = [];
        overwrite = input(sprintf('Directory %s already exists.\nReally overwrite? (y/n): ',...
            mrAnatomyDirName),'s');
        if (strcmp(overwrite,'y'))
            eval(['!rm -rf ' mrAnatomyDirName] );
            mkdir(mrAnatomyDirName);
            break;
        elseif (strcmp(overwrite,'n'))
            return;
        end
    end
else
    mkdir(mrAnatomyDirName);
end

% Now use FSL to align the separate scans
for i = 1:nScans
    averageAnalyzeFiles{i} = fullfile(sourceSubDirArray{i},[analyzeFilesLittle{i} '.img']);
end
averageAnatomyFile =fullfile(mrAnatomyDirName,averageAnalyzeFile); 
if (ALIGNANALYZE)
    averageAnalyze(averageAnalyzeFiles,averageAnatomyFile);
end

% Now use FSL BET tool to prepare the analyze format data for mrGray
betAnatomyRoot = fullfile(mrAnatomyDirName,betFileRoot);
if (PREPAREANATOMY)
    prepareAnatomy(averageAnatomyFile,betAnatomyRoot);
end

% Now make the vAnatomy.dat files for both skull stripped 
% and non-skull stripped versions.
if (CREATEVANAT)
    skullFile = [betAnatomyRoot,'_brain_homog_restore_Skull_aligned.hdr'];
    createVolAnat(skullFile,...
        fullfile(mrAnatomyDirName,vAnatomySkullName),...
        fullfile(mrAnatomyDirName,unfoldSkullName));
    noskullFile = [betAnatomyRoot,'_brain_homog_restore_aligned.hdr'];
    createVolAnat(noskullFile, ...
        fullfile(mrAnatomyDirName,vAnatomyNoSkullName), ...
        fullfile(mrAnatomyDirName,unfoldNoSkullName));
end

% Get rid of files we never plan to look at
if (CLEAN)
	dos(['rm ' betAnatomyRoot '_brain.img']);
	dos(['rm ' betAnatomyRoot '_brain.hdr']);
	dos(['rm ' betAnatomyRoot '_brain_mask.img']);
	dos(['rm ' betAnatomyRoot '_brain_mask.hdr']);
    dos(['rm ' betAnatomyRoot '_brain_homog_restore.img']);
	dos(['rm ' betAnatomyRoot '_brain_homog_restore.hdr']);
	dos(['rm ' betAnatomyRoot '_brain_homog_restore_Skull.img']);
	dos(['rm ' betAnatomyRoot '_brain_homog_restore_Skull.hdr']);
    dos(['rm ' mrAnatomyDirName filesep '*regTo1.img']);
    dos(['rm ' mrAnatomyDirName filesep '*regTo1.hdr']);
end
