function view = resetSlider(view,slider,minVal,maxVal,val)
%
%     view = resetSlider(view,slider,minVal,maxVal,val)
%
% Resets slider to have specified min, max, and value.
% Sets the sliderHandle itself as well as the text label.
% Called by setParameterMap to reset the mapWindow sliders.
%
% djh, 4/99
% ras, 04/04:   made parallel changes with makeSlider and setSlider
%               (now has edit fields w/ label)

% Set slider limits
set(slider.sliderHandle,'min',minVal);
set(slider.sliderHandle,'max',maxVal);

% Set slider value
set(slider.sliderHandle,'Value',val);

% Update slider text labels
str = sprintf('%3.3g',val);
set(slider.labelHandle,'string',str);

% Return the current axes to the main image
% BW:  I don't understand this.  It didn't work when called from open3dwindow,
% so I changed gcf to view.ui.figNum in the hopes that the change was good
% enough.  It all seemed to work and it fixed my problem.
set(view.ui.figNum,'CurrentAxes',view.ui.mainAxisHandle);

return


