function view = makeZoomButtons(view);
% Adds buttons for zooming in/out of a view.
%
% view = makeZoomButtons(view);
%
% 
% 09/04 ras.
% 02/06: made callbacks just call the axis command, rather than
% refreshing the zoom -- should be much faster.

name = view.name;
type = view.viewType;
dims = viewSize(view);

switch type
    case {'Inplane', 'Flat'},
		cb1 = sprintf('%s = zoomInplane(%s);', view.name, view.name);
		cb2 = sprintf('%s = zoomInplane(%s, 1);', view.name, view.name);                     
                     
    case {'Volume', 'Gray','generalGray'},        
		cb1 = sprintf('%s = zoom3View(%s);', view.name, view.name);
		cb2 = sprintf('%s = zoom3View(%s, 1);', view.name, view.name);     
        
    otherwise,
        error('Huh? Weird view type.');
end

but1 = uicontrol('Style', 'pushbutton', 'String', 'Zoom',...
             'Value', 0, 'Callback', cb1,...
             'BackgroundColor', [.6 .6 .6], ...
             'ForegroundColor', [0 0 0],...
             'Units', 'Normalized', ...
             'Position', [0 0.2 0.1 0.05]);

but2 = uicontrol('Style', 'pushbutton', ...
                 'String', 'Reset Zoom',...
                 'Value', 0, 'Callback', cb2,...
                 'BackgroundColor', [.8 .8 .8], ...
                 'ForegroundColor', [0 0 0],...
                 'Units', 'Normalized', ...
                 'Position', [0 0.15 0.1 0.05]); 

view.ui.zoomButtons.zoom = but1;
view.ui.zoomButtons.resetZoom = but2;

% init zoom field in view
switch type
    case {'Inplane','Flat'},
		view.ui.zoom = [1 max(2, dims(2)) 1 max(2, dims(1))];
    case {'Volume','Gray'},
        view.ui.zoom = [1 dims(1); 1 dims(2); 1 dims(3)];
end

return