function view = makeGrayVolButtons(view)
%
% view = makeGrayVolButtons(view)
%
% Installs push buttons that choose gray mode vs. volume mode for
% in the Volume view.
%
% djh, 8/98
% Ress, 6/03: Added buttons for 3D rendering.

width = .1;
height = .05;
left = .01;

% Switch-to-volume button:
bot = 0.50;
callbackStr = ...
    [view.name,'=switch2Vol(',view.name,'); ',...
	view.name,'=refreshScreen(',view.name,');'];
view.ui.grayVolButtons(2) = ...
    uicontrol('Style','radiobutton',...
    'String','Volume',...
    'Units','normalized',...
    'BackgroundColor',get(gcf,'Color'),...
    'Position',[left,bot,width,height],...
    'Callback', callbackStr);
% Switch-to-gray button
bot = 0.45;
callbackStr = ...
    [view.name,'=switch2Gray(',view.name,'); ',...
	view.name,'=refreshScreen(',view.name,');'];
view.ui.grayVolButtons(1) = ...
    uicontrol('Style','radiobutton',...
    'String','Gray',...
    'BackgroundColor',get(gcf,'Color'),...
    'Units','normalized',...
    'Position',[left,bot,width,height],...
    'Callback', callbackStr);
% Initially, select button volume view:
selectButton(view.ui.grayVolButtons, 1);

% Now add selector for 3D model
% Label
% width = 0.19;
% left = 0.001;
% bot = 0.30;
% view.ui.gray3dButtons(2) = uicontrol( ...
%     'Style', 'text', ...
%     'Units', 'normalized', ...
%     'String', '3D Model:', ...
%     'Position', [left, bot, width, height], ...
%     'HorizontalAlignment', 'left',...
%     'BackgroundColor', get(view.ui.windowHandle,'Color'));
% bot = 0.25;
% 
% % 3d model selector
% callbackStr = [view.name,'.meshNum3d = get(gcbo,''Value'');' view.name,'=Refresh3D(', view.name, ');'];
% view.ui.gray3dButtons(1) = uicontrol( ...
%     'Style', 'popupmenu',...
%     'String', {'none'},...
%     'Value', 1, ...
%     'Units', 'normalized',...
%     'Position', [left, bot, width, height],...
%     'Callback', callbackStr,...
%     'TooltipString','Load and build 3d meshes from 3D mesh submenu in Window menu.');

return;
