function anatClip = getAnatClip(view)
%
% anatClip = getAnatClip(view)
%
% Gets anatomy clipping values from anatMin and anatMax sliders
% ras 01/05: made brightness/contrast sliders in place of
% anatClip -- I find this more useful, but back compatibility
% with older functions is good. 
% I notice the anatMin is not often used for inplane
% images, so I use the difference between the anatMin & anatMax
% as the contrast. 

if isfield(view.ui,'anatMin')
	anatClip = [get(view.ui.anatMin.sliderHandle,'Value'),...
		get(view.ui.anatMax.sliderHandle,'Value')];
elseif isfield(view.ui,'contrast')
    anatClip = [1 get(view.ui.contrast.sliderHandle,'Value')];
end

return
