function view=initScanSlider(view,curScan)
%
%       view=initScanSlider(view,[curScan])
%
% Installs the slider and text box that control the current scan.
% The slider is placed on the top right, near the slice control slider.
%
% The first time through, the callback and related textbox are installed
%
% It is also called repeatedly as dataTypes are switched to re-display
%   the slider that represents scan information
%
% If you change this function make parallel changes in:
%    initSliceSlider
%
% bw,  01/16/01  Adjusted sliderstep
% bw,  12/25/00  Wrote it.

% The sliderHandle always exists because it is created in openXXWindow
% Set the step size for clicking on the arrows and the trough
sliderHandle = view.ui.scan.sliderHandle;

nScans=numScans(view);
if nScans < 2
    %   Can't have a slider value of 1.  Sorry.
    nScans=2;
    set(sliderHandle,'Enable','off');
else
    set(sliderHandle,'Enable','on');
end
    
% By setting the max to a little more than nScans, we should
% never quite reach it by clicking the arrow or the trough
set(sliderHandle,'Min',1,'Max',nScans);

% Clicking an arrow moves by an amount (max - min)*sliderstep(1)
% Cllicking in the trough moves by an amount (max - min)*sliderstep(2)
% setSlider traps any values == to the max value and queries the user
%    this is a cheap way of setting a value by hand.
sliderStep(1) = 1/(nScans - 1);
sliderStep(2) = 2*sliderStep(1);
set(sliderHandle,'sliderStep',sliderStep);


% If we are first opening the window, create the text box.  
if ~isfield(view.ui.scan, 'textHandle')
	cb = ['val = get(',view.name,'.ui.scan.sliderHandle,''value''); '...
            'val = round(val); '...
            'setSlider(',view.name,',',view.name,'.ui.scan,val); '...
            view.name '=setCurScan(',view.name,',val); '...
            view.name,'=refreshScreen(',view.name,'); '];
	set(sliderHandle,'CallBack',cb);
    
   % Position the text box to the right of the slider
   pos = get(sliderHandle,'Position');
   l2 = pos(1) + pos(3) + .01;
   w2 = pos(3)/4; b = pos(2); h = pos(4);
   position = [l2 b w2 h];
   
   view.ui.scan.textHandle = ...
      uicontrol('Style','text',...
      'Units','normalized',...
      'Position',position);
end

% This text tells the user how many scans there are
% in the current dataType.  Here, we set the value
%
str = sprintf('%.0f',nScans);
set(view.ui.scan.textHandle,'String',str);

% Synchronize the curScan with the slider state
%
if ~exist('curScan','var')
   curScan = getCurScan(view);
end
if curScan > numScans(view)
    curScan = 1;
end
setSlider(view,view.ui.scan,curScan);
view = setCurScan(view,curScan);

% ras 08/05: make the scan slider update the curScan field as well:
cb = 'val=str2num(get(gcbo,''String'')); ';
cb = [cb sprintf('%s=setCurScan(%s,val); ',view.name,view.name)];
cb = [cb sprintf('%s=refreshScreen(%s);',view.name,view.name)];
set(view.ui.scan.labelHandle,'Callback',cb);

return
