function flattenFromROI(view, ROI)
% flattenFromROI(view, [ROI])
%   Simple wrapper for mrFlatMesh GUI. Opens the GUI, filling in some
%   default starting values. Uses the center of mass of the specified
%   ROI as the start point.
%
% GLOBALS: uses mrSESSION fields to initialize the mrFlatMesh GUI.
%
% HISTORY:
% 2002.03.04 RFD (bob@white.stanford.edu): wrote it
% 7/16/02 djh, replaced mrSESSION.vAnatomyPath with global vANATOMYPATH
% 2002.07.19 RFD: cleaned up default filenames a bit
% 2006.02.05 MMS: made it work with ROIs with only one coordinate

mrGlobals

switch view.viewType
case 'Gray'
    leftGrayPath = view.leftPath;
    rightGrayPath = view.rightPath;
otherwise
    error([mfilename,': unsupported view type "',view.viewType,'".']);
end

if(~exist('ROI','var'))
    if(view.selectedROI>0)
        ROI = view.ROIs(view.selectedROI);
    else
        myErrorDlg('No ROI selected');
        return;
    end
end

mmPerPixXYZ = readVolAnatHeader(vANATOMYPATH);

startXYZ = round(mean(ROI.coords',1)');
startXYZ = [startXYZ(2);startXYZ(1);startXYZ(3)];

% Now how do we find which hemisphere this coord belongs to?

% Find the nearest grayCoord
distances = (view.coords(1,:) - startXYZ(1)).^2 + ...
            (view.coords(2,:) - startXYZ(2)).^2 + ...
            (view.coords(3,:) - startXYZ(3)).^2;
[val,index] = min(distances);
clear distances;

% FIX THIS HERE- THIS IS AN UGLY HACK FOR GUESSING THE HEMISPHERE.
% Note that the apparently useless 'fullfile' call here is a trick to get
% matlab to fix the path separators to those appropriate for the current platform.
if(view.coords(3,index)<mean(view.coords(3,:)))
    grayPath = fullfile(leftGrayPath,'');
else
    grayPath = fullfile(rightGrayPath,'');
end
[grayPathDir,grayPathFileName] = fileparts(grayPath);
if(exist(grayPath)~=2)
    if(exist(grayPathDir,'dir'))
        % at least get them close
        grayPath = grayPathDir;
    else
        grayPath = '';
        grayPathDir = '';
    end
end

% we try to guess the mesh file path
subDirs = {'','3dMeshes','3DMeshes','3Dmeshes'};
extensions = {'.MrM','.mrm','.Mrm','.MRm','.MRM'};
meshPath = grayPathDir;
for(ii=1:length(subDirs))
    for(jj=1:length(extensions))
        if(exist(fullfile(grayPathDir,subDirs{ii},[grayPathFileName,extensions{jj}]))==2)
            meshPath = fullfile(grayPathDir,subDirs{ii},[grayPathFileName,extensions{jj}]);
            break;
        end
    end
end

ts = now;
saveFileName = ['unfold_',datestr(ts,'mm'),datestr(ts, 'dd'),datestr(ts,'yy')];
if(exist(fullfile(grayPathDir,'Unfolds'), 'dir'))
    savePath = fullfile(grayPathDir, 'Unfolds', saveFileName);
else
    savePath = fullfile(grayPathDir, saveFileName);
end

unfoldRadiusMM = 60;

disp(['calling mrFlatMesh...']);

mrFlatMesh({'grayPath', grayPath, 'meshPath', meshPath, 'savePath', savePath, ...
            'scaleXYZ', mmPerPixXYZ , 'startXYZ', startXYZ, 'unfoldRadiusMM', unfoldRadiusMM});
    
    