function view = selectROI(view,n)
%
% view = selectROI(view,n)
%
% Selects the Nth ROI in view.ROIs to be the selected ROI by
% setting the view.selectedROI field.
%
% If isstr(n), then the ROI with the name n is selected.
%
% djh, 1/26/98
% bw,aab  Allowed n to be a string.
% ras, 8/17/04 -- for volume views, auto centers on the selected ROI.

if isstr(n)
    roiName = n;
    if ~isempty(view.ROIs)
        nROIs = length(view.ROIs);
        for ii=1:nROIs
            if strmatch(roiName,view.ROIs(ii).name);
                view = selectROI(view,ii);
                return;
            end
        end
        warndlg(sprintf('No ROI with name %s.',roiName));
    else
        warndlg(sprintf('No ROIs in current view.'));
    end
    
elseif ~isempty(view.ROIs)
    % Select it
    view.selectedROI = n;
    % Reset prevCoords
    view.prevCoords = [];
else
    view.selectedROI = 0;
end

% Update the ROI popup menu, if it exists
% (won't for hidden views)
if ~isequal(view.name,'hidden')
    setROIPopup(view);
end

% % for volume views, find the ROI as it's loaded
% viewType = viewGet(view,'viewType');
% if (isequal(viewType,'Volume') | isequal(viewType,'Gray')) 
%     if isfield(view,'ui') & ~isempty(view.ROIs(view.selectedROI).coords);% hidden view test
%         view = selectCurROISlice(view);
%         view = refreshScreen(view);
%     end
% end


return;