function view = restrictROI(view,refScan,cothresh,phWindow,mapWindow,ROInum)
%
% view = restrictROI(view,refScan,cothresh,phWindow,[mapWindow],[ROInum])
%
% Restricts ROI according to cothresh. phWindow, and mapWindow.
% refScan: scan number
% ROInum: defaults to selectedROI
%
% djh, modified 7/13/99, added mapWindow and optional ROInum.
% dbr, 9/28/99  Added default empty definition for mapWindow var.
% ras, 11/04 made less picky in case no corAnal is run.
if ~exist('ROInum','var')
   % error if no current ROI
   if view.selectedROI == 0
      myErrorDlg('No current ROI');
   else      
      ROInum = view.selectedROI;  
    end
end

if ~exist('mapWindow', 'var'), mapWindow = []; end

% Get current ROI coords
ROIcoords = view.ROIs(ROInum).coords;

% Save prevSelpts for undo
view.prevCoords = ROIcoords;

% Find indices of voxels that satisfy cothresh, phWindow, and mapWindow.
if ~isempty(view.ph)
	phCoords = inPhWindow(view,refScan,ROIcoords,phWindow);
	coCoords = aboveCoThresh(view,refScan,ROIcoords,cothresh);
else
    phCoords = ROIcoords;
    coCoords = ROIcoords;
end

if ~isempty(view.map)   
    mapCoords = inMapWindow(view,refScan,ROIcoords,mapWindow);
end

% Intersect the 3 sets of coords to get the indices that satisfy
% all 4 criteria (in ROI, above cothresh, within phWindow, within
% mapWindow).
coords = intersectCols(phCoords,coCoords);

if ~isempty(view.ph)
  coords = intersectCols(phCoords,coCoords);
else
  coords = ROIcoords;
end

if ~isempty(view.map)
   coords = intersectCols(coords,mapCoords);
end

% Modify ROI.coords
view.ROIs(ROInum).coords = coords;

return
