function view = replaceROIQuadrilateralCoords(view,corners)
%
% view = replaceROIQuadrilateralCoords(view,corners)
%
% Author:  BW,AAB
% Purpose:
%   Replace the coordinates in the currently selected roi with a
%   quadrilateral region defined by the corners.

curSlice = getCurSlice(view);

%
polyIm = roipoly(view.ui.image,corners(:,1),corners(:,2));

% % markPoly returns an image with 1's marking the polygon
% dims=size(view.ui.image);
% polyIm = markPoly(dims);

% Compute image coordinates
polyImIndices = find(polyIm);
polyImCoords = indices2Coords(polyImIndices,size(polyIm));

% Add curSlice as 3rd row to get volume coordinates
polyCoords = [polyImCoords; curSlice*ones(1,size(polyImCoords,2))];

% Convert coords to canonical frame of reference
polyCoords = curOri2CanOri(view,polyCoords);

view.ROIs(view.selectedROI).coords = polyCoords;

return;
